/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration;

import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import org.keycloak.common.util.StringPropertyReplacer;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.configuration.PersistedConfigSource;
import org.keycloak.quarkus.runtime.configuration.QuarkusPropertiesConfigSource;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMappers;

public class PropertyMappingInterceptor
implements ConfigSourceInterceptor {
    private final boolean isQuarkusPropertiesEnabled = QuarkusPropertiesConfigSource.isQuarkusPropertiesEnabled();

    public ConfigValue getValue(ConfigSourceInterceptorContext context, String name) {
        ConfigValue value = PropertyMappers.getValue(context, name);
        if (value == null || value.getValue() == null) {
            return null;
        }
        if (this.isPersistedOnlyProperty(value)) {
            return value.withValue(PersistedConfigSource.getInstance().getValue(name));
        }
        if (value.getValue().indexOf("${") == -1) {
            return value;
        }
        return value.withValue(StringPropertyReplacer.replaceProperties((String)value.getValue(), property -> {
            ConfigValue prop = context.proceed(property);
            if (prop == null) {
                return null;
            }
            return prop.getValue();
        }));
    }

    private boolean isPersistedOnlyProperty(ConfigValue value) {
        if (this.isQuarkusPropertiesEnabled && value.getName().startsWith("quarkus")) {
            String configSourceName = value.getConfigSourceName();
            return Environment.isRuntimeMode() != false && configSourceName != null && !configSourceName.equals("PersistedConfigSource") && !configSourceName.equals("default values") && !configSourceName.contains("Runtime Defaults") && !configSourceName.contains("application.properties");
        }
        return false;
    }
}

