/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.deployment;

import io.quarkus.agroal.spi.JdbcDataSourceBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceResultBuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.RuntimeConfigSetupCompleteBuildItem;
import io.quarkus.deployment.builditem.StaticInitConfigSourceProviderBuildItem;
import io.quarkus.hibernate.orm.deployment.AdditionalJpaModelBuildItem;
import io.quarkus.hibernate.orm.deployment.HibernateOrmConfig;
import io.quarkus.hibernate.orm.deployment.PersistenceXmlDescriptorBuildItem;
import io.quarkus.hibernate.orm.deployment.integration.HibernateOrmIntegrationRuntimeConfiguredBuildItem;
import io.quarkus.resteasy.server.common.deployment.ResteasyDeploymentCustomizerBuildItem;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.smallrye.health.runtime.SmallRyeHealthHandler;
import io.quarkus.vertx.http.deployment.FilterBuildItem;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.smallrye.config.ConfigValue;
import io.vertx.core.Handler;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.persistence.Entity;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.hibernate.jpa.boot.internal.ParsedPersistenceXmlDescriptor;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.keycloak.Config;
import org.keycloak.authentication.AuthenticatorSpi;
import org.keycloak.authentication.authenticators.browser.DeployedScriptAuthenticatorFactory;
import org.keycloak.authorization.policy.provider.PolicySpi;
import org.keycloak.authorization.policy.provider.js.DeployedScriptPolicyFactory;
import org.keycloak.common.Profile;
import org.keycloak.common.util.StreamUtil;
import org.keycloak.connections.jpa.DefaultJpaConnectionProviderFactory;
import org.keycloak.connections.jpa.JpaConnectionProvider;
import org.keycloak.connections.jpa.JpaConnectionSpi;
import org.keycloak.connections.jpa.updater.liquibase.LiquibaseJpaUpdaterProviderFactory;
import org.keycloak.connections.jpa.updater.liquibase.conn.DefaultLiquibaseConnectionProvider;
import org.keycloak.connections.jpa.util.JpaUtils;
import org.keycloak.protocol.ProtocolMapperSpi;
import org.keycloak.protocol.oidc.mappers.DeployedScriptOIDCProtocolMapper;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.KeycloakDeploymentInfo;
import org.keycloak.provider.Provider;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.provider.ProviderManager;
import org.keycloak.provider.Spi;
import org.keycloak.quarkus.deployment.IsIntegrationTest;
import org.keycloak.quarkus.deployment.IsReAugmentation;
import org.keycloak.quarkus.deployment.KeycloakSessionFactoryPreInitBuildItem;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.KeycloakRecorder;
import org.keycloak.quarkus.runtime.QuarkusProfile;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import org.keycloak.quarkus.runtime.configuration.KeycloakConfigSourceProvider;
import org.keycloak.quarkus.runtime.configuration.MicroProfileConfigProvider;
import org.keycloak.quarkus.runtime.configuration.QuarkusPropertiesConfigSource;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMappers;
import org.keycloak.quarkus.runtime.dev.QuarkusDevRequestFilter;
import org.keycloak.quarkus.runtime.integration.jaxrs.QuarkusKeycloakApplication;
import org.keycloak.quarkus.runtime.integration.web.NotFoundHandler;
import org.keycloak.quarkus.runtime.integration.web.QuarkusRequestFilter;
import org.keycloak.quarkus.runtime.storage.database.jpa.NamedJpaConnectionProviderFactory;
import org.keycloak.representations.provider.ScriptProviderDescriptor;
import org.keycloak.representations.provider.ScriptProviderMetadata;
import org.keycloak.services.ServicesLogger;
import org.keycloak.theme.FolderThemeProviderFactory;
import org.keycloak.transaction.JBossJtaTransactionManagerLookup;
import org.keycloak.url.DefaultHostnameProviderFactory;
import org.keycloak.url.FixedHostnameProviderFactory;
import org.keycloak.url.RequestHostnameProviderFactory;
import org.keycloak.util.JsonSerialization;
import org.keycloak.vault.FilesPlainTextVaultProviderFactory;

class KeycloakProcessor {
    private static final Logger logger = Logger.getLogger(KeycloakProcessor.class);
    private static final String JAR_FILE_SEPARATOR = "!/";
    private static final String DEFAULT_HEALTH_ENDPOINT = "/health";
    private static final String DEFAULT_METRICS_ENDPOINT = "/metrics";
    private static final Map<String, Function<ScriptProviderMetadata, ProviderFactory>> DEPLOYEABLE_SCRIPT_PROVIDERS = new HashMap<String, Function<ScriptProviderMetadata, ProviderFactory>>();
    private static final String KEYCLOAK_SCRIPTS_JSON_PATH = "META-INF/keycloak-scripts.json";
    private static final List<Class<? extends ProviderFactory>> IGNORED_PROVIDER_FACTORY = Arrays.asList(JBossJtaTransactionManagerLookup.class, DefaultJpaConnectionProviderFactory.class, DefaultLiquibaseConnectionProvider.class, FolderThemeProviderFactory.class, LiquibaseJpaUpdaterProviderFactory.class, DefaultHostnameProviderFactory.class, FixedHostnameProviderFactory.class, RequestHostnameProviderFactory.class, FilesPlainTextVaultProviderFactory.class);

    KeycloakProcessor() {
    }

    private static ProviderFactory registerScriptAuthenticator(ScriptProviderMetadata metadata) {
        return new DeployedScriptAuthenticatorFactory(metadata);
    }

    private static ProviderFactory registerScriptPolicy(ScriptProviderMetadata metadata) {
        return new DeployedScriptPolicyFactory(metadata);
    }

    private static ProviderFactory registerScriptMapper(ScriptProviderMetadata metadata) {
        return new DeployedScriptOIDCProtocolMapper(metadata);
    }

    @BuildStep
    FeatureBuildItem getFeature() {
        return new FeatureBuildItem("keycloak");
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void configurePersistenceUnits(HibernateOrmConfig config, List<PersistenceXmlDescriptorBuildItem> descriptors, List<JdbcDataSourceBuildItem> jdbcDataSources, BuildProducer<AdditionalJpaModelBuildItem> additionalJpaModel, CombinedIndexBuildItem indexBuildItem, BuildProducer<HibernateOrmIntegrationRuntimeConfiguredBuildItem> runtimeConfigured, KeycloakRecorder recorder) {
        for (PersistenceXmlDescriptorBuildItem item : descriptors) {
            ParsedPersistenceXmlDescriptor descriptor = item.getDescriptor();
            if ("keycloak-default".equals(descriptor.getName())) {
                this.configureJpaProperties(descriptor, config, jdbcDataSources);
                this.configureJpaModel(descriptor, indexBuildItem);
                continue;
            }
            Properties properties = descriptor.getProperties();
            runtimeConfigured.produce((BuildItem)new HibernateOrmIntegrationRuntimeConfiguredBuildItem("keycloak", descriptor.getName()).setInitListener(recorder.createUnitListener(properties.getProperty("hibernate.connection.datasource"))));
        }
    }

    private void configureJpaProperties(ParsedPersistenceXmlDescriptor descriptor, HibernateOrmConfig config, List<JdbcDataSourceBuildItem> jdbcDataSources) {
        Properties unitProperties = descriptor.getProperties();
        unitProperties.setProperty("hibernate.dialect", config.defaultPersistenceUnit.dialect.dialect.orElse(null));
        unitProperties.setProperty("javax.persistence.transactionType", PersistenceUnitTransactionType.JTA.name());
        unitProperties.setProperty("hibernate.query.startup_check", Boolean.FALSE.toString());
        String dbKind = jdbcDataSources.get(0).getDbKind();
        for (Map.Entry<Object, Object> query : JpaUtils.loadSpecificNamedQueries((String)dbKind.toLowerCase()).entrySet()) {
            unitProperties.setProperty("kc.query." + query.getKey(), query.getValue().toString());
        }
    }

    private void configureJpaModel(ParsedPersistenceXmlDescriptor descriptor, CombinedIndexBuildItem indexBuildItem) {
        IndexView index = indexBuildItem.getIndex();
        Collection annotations = index.getAnnotations(DotName.createSimple((String)Entity.class.getName()));
        for (AnnotationInstance annotation : annotations) {
            AnnotationTarget target = annotation.target();
            String targetName = target.asClass().name().toString();
            if (!this.isCustomJpaModel(targetName)) continue;
            descriptor.addClasses(new String[]{targetName});
        }
    }

    private boolean isCustomJpaModel(String targetName) {
        return !targetName.startsWith("org.keycloak") || targetName.startsWith("org.keycloak.testsuite");
    }

    @Consume(value=RuntimeConfigSetupCompleteBuildItem.class)
    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    KeycloakSessionFactoryPreInitBuildItem configureProviders(KeycloakRecorder recorder, List<PersistenceXmlDescriptorBuildItem> descriptors) {
        Profile.setInstance((Profile)new QuarkusProfile());
        HashMap<Spi, Map<Class<? extends Provider>, Map<String, Class<? extends ProviderFactory>>>> factories = new HashMap<Spi, Map<Class<? extends Provider>, Map<String, Class<? extends ProviderFactory>>>>();
        HashMap<Class<? extends Provider>, String> defaultProviders = new HashMap<Class<? extends Provider>, String>();
        HashMap<String, ProviderFactory> preConfiguredProviders = new HashMap<String, ProviderFactory>();
        for (Map.Entry<Spi, Map<Class<? extends Provider>, Map<String, ProviderFactory>>> entry : this.loadFactories(preConfiguredProviders).entrySet()) {
            Spi spi = entry.getKey();
            this.checkProviders(spi, entry.getValue(), defaultProviders);
            for (Map.Entry<Class<? extends Provider>, Map<String, ProviderFactory>> value : entry.getValue().entrySet()) {
                for (ProviderFactory factory : value.getValue().values()) {
                    factories.computeIfAbsent(spi, key -> new HashMap()).computeIfAbsent(spi.getProviderClass(), aClass -> new HashMap()).put(factory.getId(), factory.getClass());
                }
            }
            if (!(spi instanceof JpaConnectionSpi)) continue;
            this.configureUserDefinedPersistenceUnits(descriptors, factories, preConfiguredProviders, spi);
        }
        recorder.configSessionFactory(factories, defaultProviders, preConfiguredProviders, Environment.isRebuild());
        return new KeycloakSessionFactoryPreInitBuildItem();
    }

    private void configureUserDefinedPersistenceUnits(List<PersistenceXmlDescriptorBuildItem> descriptors, final Map<Spi, Map<Class<? extends Provider>, Map<String, Class<? extends ProviderFactory>>>> factories, final Map<String, ProviderFactory> preConfiguredProviders, final Spi spi) {
        descriptors.stream().map(PersistenceXmlDescriptorBuildItem::getDescriptor).map(ParsedPersistenceXmlDescriptor::getName).filter(Predicate.not("keycloak-default"::equals)).forEach(new Consumer<String>(){

            @Override
            public void accept(String unitName) {
                NamedJpaConnectionProviderFactory factory = new NamedJpaConnectionProviderFactory();
                factory.setUnitName(unitName);
                ((Map)((Map)factories.get(spi)).get(JpaConnectionProvider.class)).put(unitName, NamedJpaConnectionProviderFactory.class);
                preConfiguredProviders.put(unitName, factory);
            }
        });
    }

    @BuildStep(onlyIfNot={IsIntegrationTest.class})
    void configureConfigSources(BuildProducer<StaticInitConfigSourceProviderBuildItem> configSources) {
        configSources.produce((BuildItem)new StaticInitConfigSourceProviderBuildItem(KeycloakConfigSourceProvider.class.getName()));
    }

    @BuildStep(onlyIf={IsIntegrationTest.class})
    void prepareTestEnvironment(BuildProducer<StaticInitConfigSourceProviderBuildItem> configSources, DevServicesDatasourceResultBuildItem dbConfig) {
        configSources.produce((BuildItem)new StaticInitConfigSourceProviderBuildItem("org.keycloak.quarkus.runtime.configuration.test.TestKeycloakConfigSourceProvider"));
        if (dbConfig != null && dbConfig.getDefaultDatasource() != null) {
            Map configProperties = dbConfig.getDefaultDatasource().getConfigProperties();
            for (Map.Entry dbConfigProperty : configProperties.entrySet()) {
                String kcProperty;
                PropertyMapper mapper = PropertyMappers.getMapper((String)((String)dbConfigProperty.getKey()));
                if (mapper == null || (kcProperty = mapper.getFrom()).endsWith("db")) continue;
                System.setProperty(kcProperty, (String)dbConfigProperty.getValue());
            }
        }
    }

    @BuildStep(onlyIf={IsReAugmentation.class})
    void persistBuildTimeProperties(BuildProducer<GeneratedResourceBuildItem> resources) {
        Properties properties = new Properties();
        for (String name : Configuration.getPropertyNames()) {
            PropertyMapper mapper = PropertyMappers.getMapper((String)name);
            ConfigValue value = null;
            if (mapper == null) {
                if (name.startsWith("quarkus") && !QuarkusPropertiesConfigSource.isSameSource((ConfigValue)(value = Configuration.getConfigValue((String)name)))) {
                    continue;
                }
            } else if (mapper.isBuildTime()) {
                name = mapper.getFrom();
                value = Configuration.getConfigValue((String)name);
            }
            if (value == null || value.getValue() == null) continue;
            properties.put(name, value.getValue());
        }
        for (File jar : Environment.getProviderFiles().values()) {
            properties.put(String.format("kc.provider.file.%s.last-modified", jar.getName()), String.valueOf(jar.lastModified()));
        }
        String profile = Environment.getProfile();
        if (profile != null) {
            properties.put("kc.profile", profile);
            properties.put("quarkus.profile", profile);
        }
        properties.put("kc.quarkus-properties-enabled", String.valueOf(QuarkusPropertiesConfigSource.getConfigurationFile() != null));
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            properties.store(outputStream, " Auto-generated, DO NOT change this file");
            resources.produce((BuildItem)new GeneratedResourceBuildItem("META-INF/keycloak-persisted.properties", outputStream.toByteArray()));
        }
        catch (Exception cause) {
            throw new RuntimeException("Failed to persist configuration", cause);
        }
    }

    @BuildStep
    void index(BuildProducer<IndexDependencyBuildItem> indexDependencyBuildItemBuildProducer) {
        indexDependencyBuildItemBuildProducer.produce((BuildItem)new IndexDependencyBuildItem("org.liquibase", "liquibase-core"));
        indexDependencyBuildItemBuildProducer.produce((BuildItem)new IndexDependencyBuildItem("org.keycloak", "keycloak-services"));
    }

    @BuildStep
    void initializeFilter(BuildProducer<FilterBuildItem> filters, LaunchModeBuildItem launchModeBuildItem) {
        QuarkusRequestFilter filter = new QuarkusRequestFilter();
        LaunchMode launchMode = launchModeBuildItem.getLaunchMode();
        if (launchMode.isDevOrTest()) {
            filter = new QuarkusDevRequestFilter();
        }
        filters.produce((BuildItem)new FilterBuildItem((Handler)filter, 90));
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void initializeMetrics(KeycloakRecorder recorder, BuildProducer<RouteBuildItem> routes, NonApplicationRootPathBuildItem nonAppRootPath) {
        NotFoundHandler metricsHandler;
        SmallRyeHealthHandler healthHandler;
        if (this.isMetricsEnabled()) {
            healthHandler = new SmallRyeHealthHandler();
            String rootPath = nonAppRootPath.getNormalizedHttpRootPath();
            metricsHandler = recorder.createMetricsHandler(rootPath.concat(DEFAULT_METRICS_ENDPOINT).replace("//", "/"));
        } else {
            healthHandler = new NotFoundHandler();
            metricsHandler = new NotFoundHandler();
        }
        routes.produce((BuildItem)RouteBuildItem.builder().route(DEFAULT_HEALTH_ENDPOINT).handler((Handler)healthHandler).build());
        routes.produce((BuildItem)RouteBuildItem.builder().route(DEFAULT_HEALTH_ENDPOINT.concat("/live")).handler((Handler)healthHandler).build());
        routes.produce((BuildItem)RouteBuildItem.builder().route(DEFAULT_HEALTH_ENDPOINT.concat("/ready")).handler((Handler)healthHandler).build());
        routes.produce((BuildItem)RouteBuildItem.builder().route(DEFAULT_METRICS_ENDPOINT).handler((Handler)metricsHandler).build());
    }

    @BuildStep
    void configureResteasy(BuildProducer<ResteasyDeploymentCustomizerBuildItem> deploymentCustomizerProducer) {
        deploymentCustomizerProducer.produce((BuildItem)new ResteasyDeploymentCustomizerBuildItem((Consumer)new Consumer<ResteasyDeployment>(){

            @Override
            public void accept(ResteasyDeployment resteasyDeployment) {
                resteasyDeployment.setApplicationClass(QuarkusKeycloakApplication.class.getName());
                resteasyDeployment.setProperty("resteasy.disable.html.sanitizer", (Object)Boolean.TRUE);
            }
        }));
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    void configureDevMode(BuildProducer<HotDeploymentWatchedFileBuildItem> hotFiles) {
        hotFiles.produce((BuildItem)new HotDeploymentWatchedFileBuildItem("META-INF/keycloak.conf"));
    }

    private Map<Spi, Map<Class<? extends Provider>, Map<String, ProviderFactory>>> loadFactories(Map<String, ProviderFactory> preConfiguredProviders) {
        Config.init((Config.ConfigProvider)new MicroProfileConfigProvider());
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        KeycloakDeploymentInfo keycloakDeploymentInfo = KeycloakDeploymentInfo.create().name("classpath").services().themeResources();
        ProviderManager pm = new ProviderManager(keycloakDeploymentInfo, classLoader, new String[0]);
        HashMap<Spi, Map<Class<? extends Provider>, Map<String, ProviderFactory>>> factories = new HashMap<Spi, Map<Class<? extends Provider>, Map<String, ProviderFactory>>>();
        for (Spi spi : pm.loadSpis()) {
            HashMap<Class, Map> providers = new HashMap<Class, Map>();
            ArrayList<ProviderFactory> loadedFactories = new ArrayList<ProviderFactory>(pm.load(spi));
            Map<String, ProviderFactory> deployedScriptProviders = this.loadDeployedScriptProviders(classLoader, spi);
            loadedFactories.addAll(deployedScriptProviders.values());
            preConfiguredProviders.putAll(deployedScriptProviders);
            for (ProviderFactory factory : loadedFactories) {
                if (IGNORED_PROVIDER_FACTORY.contains(factory.getClass())) continue;
                Config.Scope scope = Config.scope((String[])new String[]{spi.getName(), factory.getId()});
                if (this.isEnabled(factory, scope)) {
                    if (spi.isInternal() && !this.isInternal(factory)) {
                        ServicesLogger.LOGGER.spiMayChange(factory.getId(), factory.getClass().getName(), spi.getName());
                    }
                    providers.computeIfAbsent(spi.getProviderClass(), aClass -> new HashMap()).put(factory.getId(), factory);
                    continue;
                }
                logger.debugv("SPI {0} provider {1} disabled", (Object)spi.getName(), (Object)factory.getId());
            }
            factories.put(spi, providers);
        }
        return factories;
    }

    private Map<String, ProviderFactory> loadDeployedScriptProviders(ClassLoader classLoader, Spi spi) {
        HashMap<String, ProviderFactory> providers = new HashMap<String, ProviderFactory>();
        if (this.supportsDeployeableScripts(spi)) {
            try {
                Enumeration<URL> urls = classLoader.getResources(KEYCLOAK_SCRIPTS_JSON_PATH);
                while (urls.hasMoreElements()) {
                    ScriptProviderDescriptor descriptor;
                    URL url = urls.nextElement();
                    int fileSeparator = url.getFile().indexOf(JAR_FILE_SEPARATOR);
                    if (fileSeparator == -1) continue;
                    JarFile jarFile = new JarFile(url.getFile().substring("file:".length(), fileSeparator));
                    JarEntry descriptorEntry = jarFile.getJarEntry(KEYCLOAK_SCRIPTS_JSON_PATH);
                    try (InputStream is = jarFile.getInputStream(descriptorEntry);){
                        descriptor = (ScriptProviderDescriptor)JsonSerialization.readValue((InputStream)is, ScriptProviderDescriptor.class);
                    }
                    for (Map.Entry<String, List<ScriptProviderMetadata>> entry : descriptor.getProviders().entrySet()) {
                        if (!this.isScriptForSpi(spi, (String)entry.getKey())) continue;
                        for (ScriptProviderMetadata metadata : (List)entry.getValue()) {
                            ProviderFactory provider = this.createDeployableScriptProvider(jarFile, entry, metadata);
                            providers.put(metadata.getId(), provider);
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to discover script providers", e);
            }
        }
        return providers;
    }

    private ProviderFactory createDeployableScriptProvider(JarFile jarFile, Map.Entry<String, List<ScriptProviderMetadata>> entry, ScriptProviderMetadata metadata) throws IOException {
        String fileName = metadata.getFileName();
        if (fileName == null) {
            throw new RuntimeException("You must provide the script file name");
        }
        JarEntry scriptFile = jarFile.getJarEntry(fileName);
        try (InputStream in = jarFile.getInputStream(scriptFile);){
            metadata.setCode(StreamUtil.readString((InputStream)in, (Charset)StandardCharsets.UTF_8));
        }
        metadata.setId("script" + "-" + fileName);
        String name = metadata.getName();
        if (name == null) {
            name = fileName;
        }
        metadata.setName(name);
        return DEPLOYEABLE_SCRIPT_PROVIDERS.get(entry.getKey()).apply(metadata);
    }

    private boolean isScriptForSpi(Spi spi, String type) {
        if (spi instanceof ProtocolMapperSpi && "mappers".equals(type)) {
            return true;
        }
        if (spi instanceof PolicySpi && "policies".equals(type)) {
            return true;
        }
        return spi instanceof AuthenticatorSpi && "authenticators".equals(type);
    }

    private boolean supportsDeployeableScripts(Spi spi) {
        return spi instanceof ProtocolMapperSpi || spi instanceof PolicySpi || spi instanceof AuthenticatorSpi;
    }

    private boolean isEnabled(ProviderFactory factory, Config.Scope scope) {
        if (!scope.getBoolean("enabled", Boolean.valueOf(true)).booleanValue()) {
            return false;
        }
        if (factory instanceof EnvironmentDependentProviderFactory) {
            return ((EnvironmentDependentProviderFactory)factory).isSupported(scope);
        }
        return true;
    }

    private boolean isInternal(ProviderFactory<?> factory) {
        String packageName = factory.getClass().getPackage().getName();
        return packageName.startsWith("org.keycloak") && !packageName.startsWith("org.keycloak.examples");
    }

    private void checkProviders(Spi spi, Map<Class<? extends Provider>, Map<String, ProviderFactory>> factoriesMap, Map<Class<? extends Provider>, String> defaultProviders) {
        String defaultProvider = Config.getProvider((String)spi.getName());
        if (defaultProvider != null) {
            Map<String, ProviderFactory> map = factoriesMap.get(spi.getProviderClass());
            if (map == null || map.get(defaultProvider) == null) {
                throw new RuntimeException("Failed to find provider " + defaultProvider + " for " + spi.getName());
            }
        } else {
            Optional<ProviderFactory> highestPriority;
            Map<String, ProviderFactory> factories = factoriesMap.get(spi.getProviderClass());
            if (factories != null && factories.size() == 1) {
                defaultProvider = factories.values().iterator().next().getId();
            }
            if (factories != null && defaultProvider == null && (highestPriority = factories.values().stream().max(Comparator.comparing(ProviderFactory::order))).isPresent() && highestPriority.get().order() > 0) {
                defaultProvider = highestPriority.get().getId();
            }
            if (defaultProvider == null && (factories == null || factories.containsKey("default"))) {
                defaultProvider = "default";
            }
        }
        if (defaultProvider != null) {
            defaultProviders.put(spi.getProviderClass(), defaultProvider);
        } else {
            logger.debugv("No default provider for {0}", (Object)spi.getName());
        }
    }

    private boolean isMetricsEnabled() {
        return Configuration.getOptionalBooleanValue((String)"kc.".concat("metrics-enabled")).orElse(false);
    }

    static {
        DEPLOYEABLE_SCRIPT_PROVIDERS.put("authenticators", KeycloakProcessor::registerScriptAuthenticator);
        DEPLOYEABLE_SCRIPT_PROVIDERS.put("policies", KeycloakProcessor::registerScriptPolicy);
        DEPLOYEABLE_SCRIPT_PROVIDERS.put("mappers", KeycloakProcessor::registerScriptMapper);
    }
}

