/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment;

import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.vertx.http.deployment.devmode.NotFoundPageDisplayableEndpointBuildItem;
import io.quarkus.vertx.http.deployment.devmode.console.ConfiguredPathInfo;
import io.quarkus.vertx.http.runtime.BasicRoute;
import io.quarkus.vertx.http.runtime.HandlerType;
import io.vertx.core.Handler;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.util.function.Consumer;
import java.util.function.Function;

public final class RouteBuildItem
extends MultiBuildItem {
    private final Function<Router, Route> routeFunction;
    private final Handler<RoutingContext> handler;
    private final HandlerType type;
    private final RouteType routeType;
    private final NotFoundPageDisplayableEndpointBuildItem notFoundPageDisplayableEndpoint;
    private final ConfiguredPathInfo devConsoleResolvedPathBuildItem;

    public static Builder builder() {
        return new Builder();
    }

    RouteBuildItem(Builder builder, RouteType routeType) {
        this.routeFunction = builder.routeFunction;
        this.handler = builder.handler;
        this.type = builder.type;
        this.routeType = routeType;
        this.notFoundPageDisplayableEndpoint = builder.getNotFoundEndpoint();
        this.devConsoleResolvedPathBuildItem = builder.getRouteConfigInfo();
    }

    public Handler<RoutingContext> getHandler() {
        return this.handler;
    }

    public HandlerType getType() {
        return this.type;
    }

    public Function<Router, Route> getRouteFunction() {
        return this.routeFunction;
    }

    public boolean isFrameworkRoute() {
        return this.routeType.equals((Object)RouteType.FRAMEWORK_ROUTE);
    }

    public boolean isApplicationRoute() {
        return this.routeType.equals((Object)RouteType.APPLICATION_ROUTE);
    }

    public boolean isAbsoluteRoute() {
        return this.routeType.equals((Object)RouteType.ABSOLUTE_ROUTE);
    }

    public NotFoundPageDisplayableEndpointBuildItem getNotFoundPageDisplayableEndpoint() {
        return this.notFoundPageDisplayableEndpoint;
    }

    public ConfiguredPathInfo getDevConsoleResolvedPath() {
        return this.devConsoleResolvedPathBuildItem;
    }

    public static class Builder {
        protected Function<Router, Route> routeFunction;
        protected Handler<RoutingContext> handler;
        protected HandlerType type = HandlerType.NORMAL;
        protected boolean displayOnNotFoundPage;
        protected String notFoundPageTitle;
        protected String notFoundPagePath;
        protected String routePath;
        protected String routeConfigKey;
        protected String absolutePath;

        @Deprecated
        public Builder routeFunction(Function<Router, Route> routeFunction) {
            this.routeFunction = routeFunction;
            return this;
        }

        public Builder routeFunction(String path, Consumer<Route> routeFunction) {
            this.routeFunction = new BasicRoute(path, null, routeFunction);
            this.notFoundPagePath = this.routePath = path;
            return this;
        }

        public Builder route(String route) {
            this.routeFunction = new BasicRoute(route);
            this.notFoundPagePath = this.routePath = route;
            return this;
        }

        public Builder orderedRoute(String route, Integer order) {
            this.routeFunction = new BasicRoute(route, order);
            this.notFoundPagePath = this.routePath = route;
            return this;
        }

        public Builder handler(Handler<RoutingContext> handler) {
            this.handler = handler;
            return this;
        }

        public Builder handlerType(HandlerType handlerType) {
            this.type = handlerType;
            return this;
        }

        public Builder blockingRoute() {
            this.type = HandlerType.BLOCKING;
            return this;
        }

        public Builder failureRoute() {
            this.type = HandlerType.FAILURE;
            return this;
        }

        public Builder displayOnNotFoundPage() {
            this.displayOnNotFoundPage = true;
            return this;
        }

        public Builder displayOnNotFoundPage(String notFoundPageTitle) {
            this.displayOnNotFoundPage = true;
            this.notFoundPageTitle = notFoundPageTitle;
            return this;
        }

        public Builder routeConfigKey(String attributeName) {
            this.routeConfigKey = attributeName;
            return this;
        }

        public RouteBuildItem build() {
            return new RouteBuildItem(this, RouteType.APPLICATION_ROUTE);
        }

        protected ConfiguredPathInfo getRouteConfigInfo() {
            if (this.routeConfigKey == null) {
                return null;
            }
            if (this.routePath == null) {
                throw new RuntimeException("Cannot discover value of " + this.routeConfigKey + " as no explicit path was specified and a route function is in use");
            }
            if (this.absolutePath != null) {
                return new ConfiguredPathInfo(this.routeConfigKey, this.absolutePath, true);
            }
            return new ConfiguredPathInfo(this.routeConfigKey, this.routePath, false);
        }

        protected NotFoundPageDisplayableEndpointBuildItem getNotFoundEndpoint() {
            if (!this.displayOnNotFoundPage) {
                return null;
            }
            if (this.notFoundPagePath == null) {
                throw new RuntimeException("Cannot display " + this.routeFunction + " on not found page as no explicit path was specified and a route function is in use");
            }
            if (this.absolutePath != null) {
                return new NotFoundPageDisplayableEndpointBuildItem(this.absolutePath, this.notFoundPageTitle, true);
            }
            return new NotFoundPageDisplayableEndpointBuildItem(this.notFoundPagePath, this.notFoundPageTitle, false);
        }
    }

    public static enum RouteType {
        FRAMEWORK_ROUTE,
        APPLICATION_ROUTE,
        ABSOLUTE_ROUTE;

    }
}

