/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.metrics.runtime;

import io.quarkus.smallrye.metrics.runtime.FilterUtil;
import io.quarkus.vertx.http.runtime.CurrentVertxRequest;
import io.vertx.ext.web.RoutingContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.enterprise.inject.spi.CDI;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;

public class QuarkusRestEasyMetricsFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    @Context
    ResourceInfo resourceInfo;

    public void filter(ContainerRequestContext requestContext) {
        Long start = System.nanoTime();
        Class resourceClass = this.resourceInfo.getResourceClass();
        Method resourceMethod = this.resourceInfo.getResourceMethod();
        FilterUtil.maybeCreateMetrics(resourceClass, resourceMethod);
        RoutingContext routingContext = ((CurrentVertxRequest)CDI.current().select(CurrentVertxRequest.class, new Annotation[0]).get()).getCurrent();
        routingContext.addBodyEndHandler(event -> FilterUtil.finishRequest(start, resourceClass, resourceMethod.getName(), resourceMethod.getParameterTypes(), () -> requestContext.getProperty("smallrye.metrics.jaxrs.successful") != null));
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        requestContext.setProperty("smallrye.metrics.jaxrs.successful", (Object)true);
    }
}

