/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.admin.embeddedserver;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.EmbeddedCacheManagerAdmin;
import org.infinispan.server.core.admin.embeddedserver.CacheCreateTask;

public class TemplateCreateTask
extends CacheCreateTask {
    private static final Set<String> PARAMETERS;

    @Override
    public String getTaskContextName() {
        return "template";
    }

    @Override
    public String getTaskOperationName() {
        return "create";
    }

    @Override
    public Set<String> getParameters() {
        return PARAMETERS;
    }

    @Override
    protected Void execute(EmbeddedCacheManager cacheManager, Map<String, List<String>> parameters, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        String name = this.requireParameter(parameters, "name");
        String configuration = this.requireParameter(parameters, "configuration");
        Configuration config = this.getConfigurationBuilder(name, configuration).build();
        if (!cacheManager.getCacheManagerConfiguration().isClustered() && config.clustering().cacheMode().isClustered()) {
            throw log.cannotCreateClusteredCache();
        }
        ((EmbeddedCacheManagerAdmin)cacheManager.administration().withFlags(flags)).createTemplate(name, config);
        return null;
    }

    static {
        HashSet<String> params = new HashSet<String>(2);
        params.add("name");
        params.add("configuration");
        PARAMETERS = Collections.unmodifiableSet(params);
    }
}

