/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.cli;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.keycloak.quarkus.runtime.cli.OptionRenderer;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMappers;
import org.keycloak.utils.StringUtil;
import picocli.CommandLine;

public final class Help
extends CommandLine.Help {
    static final String[] OPTION_NAMES = new String[]{"-h", "--help"};
    private static final int HELP_WIDTH = 100;
    private static final String DEFAULT_OPTION_LIST_HEADING = "Options:";
    private static final String DEFAULT_COMMAND_LIST_HEADING = "Commands:";
    private boolean allOptions;

    Help(CommandLine.Model.CommandSpec commandSpec, CommandLine.Help.ColorScheme colorScheme) {
        super(commandSpec, colorScheme);
        this.configureUsageMessage(commandSpec);
    }

    public CommandLine.Help.Layout createDefaultLayout() {
        return new CommandLine.Help.Layout(this.colorScheme(), this.createTextTable(), this.createDefaultOptionRenderer(), this.createDefaultParameterRenderer()){

            public void addOption(CommandLine.Model.OptionSpec option, CommandLine.Help.IParamLabelRenderer paramLabelRenderer) {
                if (Help.this.isVisible(option)) {
                    super.addOption(option, paramLabelRenderer);
                }
            }
        };
    }

    private CommandLine.Help.TextTable createTextTable() {
        int longOptionsColumnWidth = this.commandSpec().commandLine().getUsageHelpLongOptionsMaxWidth();
        int descriptionWidth = 100 - longOptionsColumnWidth;
        CommandLine.Help.TextTable textTable = CommandLine.Help.TextTable.forColumns((CommandLine.Help.ColorScheme)this.colorScheme(), (CommandLine.Help.Column[])new CommandLine.Help.Column[]{new CommandLine.Help.Column(longOptionsColumnWidth, 0, CommandLine.Help.Column.Overflow.SPAN), new CommandLine.Help.Column(descriptionWidth, 1, CommandLine.Help.Column.Overflow.WRAP)});
        textTable.setAdjustLineBreaksForWideCJKCharacters(this.commandSpec().usageMessage().adjustLineBreaksForWideCJKCharacters());
        return textTable;
    }

    public CommandLine.Help.IOptionRenderer createDefaultOptionRenderer() {
        return new OptionRenderer();
    }

    public String createHeading(String text, Object ... params) {
        if (StringUtil.isBlank((String)text)) {
            return super.createHeading(text, params);
        }
        return super.createHeading("%n@|bold " + text + "|@%n%n", params);
    }

    public CommandLine.Help.IParameterRenderer createDefaultParameterRenderer() {
        return new CommandLine.Help.IParameterRenderer(){

            public CommandLine.Help.Ansi.Text[][] render(CommandLine.Model.PositionalParamSpec param, CommandLine.Help.IParamLabelRenderer parameterLabelRenderer, CommandLine.Help.ColorScheme scheme) {
                return new CommandLine.Help.Ansi.Text[0][];
            }
        };
    }

    public List<CommandLine.Model.ArgGroupSpec> optionSectionGroups() {
        List allGroupSpecs = super.optionSectionGroups();
        ArrayList<CommandLine.Model.ArgGroupSpec> nonEmptyGroups = new ArrayList<CommandLine.Model.ArgGroupSpec>(allGroupSpecs);
        Iterator argGroupSpecsIt = nonEmptyGroups.iterator();
        while (argGroupSpecsIt.hasNext()) {
            CommandLine.Model.ArgGroupSpec argGroupSpec = (CommandLine.Model.ArgGroupSpec)argGroupSpecsIt.next();
            if (argGroupSpec.options().stream().anyMatch(this::isVisible)) continue;
            argGroupSpecsIt.remove();
        }
        return nonEmptyGroups;
    }

    private void configureUsageMessage(CommandLine.Model.CommandSpec commandSpec) {
        commandSpec.usageMessage().abbreviateSynopsis(true).optionListHeading(DEFAULT_OPTION_LIST_HEADING).commandListHeading(DEFAULT_COMMAND_LIST_HEADING);
    }

    private boolean isVisible(CommandLine.Model.OptionSpec option) {
        boolean isBuildTimeProperty;
        if (this.allOptions) {
            return true;
        }
        String optionName = option.longestName();
        boolean isFeatureOption = optionName.startsWith("--feature");
        String canonicalOptionName = "kc.".concat(optionName.replace("--", ""));
        String propertyName = Configuration.getMappedPropertyName(canonicalOptionName);
        PropertyMapper mapper = PropertyMappers.getMapper(propertyName);
        if (mapper == null && !isFeatureOption) {
            return true;
        }
        String commandName = this.commandSpec().name();
        boolean bl = isBuildTimeProperty = isFeatureOption || mapper.isBuildTime();
        if ("build".equals(commandName)) {
            return isBuildTimeProperty;
        }
        if ("start-dev".equals(commandName)) {
            return !isBuildTimeProperty;
        }
        return true;
    }

    public void setAllOptions(boolean allOptions) {
        this.allOptions = allOptions;
    }
}

