/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.storage.database.jpa;

import com.fasterxml.jackson.core.type.TypeReference;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableInstance;
import io.quarkus.runtime.Quarkus;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringTokenizer;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.ServerStartupError;
import org.keycloak.common.Version;
import org.keycloak.common.util.StringPropertyReplacer;
import org.keycloak.connections.jpa.DefaultJpaConnectionProvider;
import org.keycloak.connections.jpa.JpaConnectionProvider;
import org.keycloak.connections.jpa.updater.JpaUpdaterProvider;
import org.keycloak.connections.jpa.util.JpaUtils;
import org.keycloak.exportimport.ExportImportManager;
import org.keycloak.migration.MigrationModelManager;
import org.keycloak.migration.ModelVersion;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.models.dblock.DBLockManager;
import org.keycloak.models.dblock.DBLockProvider;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.provider.ServerInfoAwareProviderFactory;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.storage.database.jpa.AbstractJpaConnectionProviderFactory;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.managers.ApplianceBootstrap;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.transaction.JtaTransactionManagerLookup;
import org.keycloak.util.JsonSerialization;

public class QuarkusJpaConnectionProviderFactory
extends AbstractJpaConnectionProviderFactory
implements ServerInfoAwareProviderFactory {
    public static final String QUERY_PROPERTY_PREFIX = "kc.query.";
    private static final Logger logger = Logger.getLogger(QuarkusJpaConnectionProviderFactory.class);
    private static final String SQL_GET_LATEST_VERSION = "SELECT ID, VERSION FROM %sMIGRATION_MODEL ORDER BY UPDATE_TIME DESC";
    private Map<String, String> operationalInfo;
    private KeycloakSessionFactory factory;

    public JpaConnectionProvider create(KeycloakSession session) {
        logger.trace((Object)"Create QuarkusJpaConnectionProvider");
        return new DefaultJpaConnectionProvider(this.createEntityManager(this.entityManagerFactory, session));
    }

    public String getId() {
        return "quarkus";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSpecificNamedQueries(KeycloakSession session) {
        EntityManager em = this.createEntityManager(this.entityManagerFactory, session);
        try {
            Map unitProperties = this.entityManagerFactory.getProperties();
            for (Map.Entry entry : unitProperties.entrySet()) {
                if (!((String)entry.getKey()).startsWith(QUERY_PROPERTY_PREFIX)) continue;
                JpaUtils.configureNamedQuery((String)((String)entry.getKey()).substring(QUERY_PROPERTY_PREFIX.length()), (String)entry.getValue().toString(), (EntityManager)em);
            }
        }
        finally {
            JpaUtils.closeEntityManager((EntityManager)em);
        }
    }

    @Override
    public void postInit(KeycloakSessionFactory factory) {
        boolean schemaChanged;
        super.postInit(factory);
        this.factory = factory;
        KeycloakSession session = factory.create();
        String id = null;
        String version = null;
        String schema = this.getSchema();
        try (Connection connection = this.getConnection();){
            try (Statement statement = connection.createStatement();
                 ResultSet rs = statement.executeQuery(String.format(SQL_GET_LATEST_VERSION, this.getSchema(schema)));){
                if (rs.next()) {
                    id = rs.getString(1);
                    version = rs.getString(2);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.createOperationalInfo(connection);
            this.addSpecificNamedQueries(session);
            schemaChanged = this.createOrUpdateSchema(schema, version, connection, session);
        }
        catch (SQLException cause) {
            throw new RuntimeException("Failed to update database.", cause);
        }
        finally {
            session.close();
        }
        if (schemaChanged || Environment.isImportExportMode()) {
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)factory, this::initSchema);
        } else if (System.getProperty("keycloak.import") != null) {
            this.importRealms();
        } else {
            Version.RESOURCES_VERSION = id;
        }
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        return ProviderConfigurationBuilder.create().property().name("initializeEmpty").type("boolean").helpText("Initialize database if empty. If set to false the database has to be manually initialized. If you want to manually initialize the database set migrationStrategy to manual which will create a file with SQL commands to initialize the database.").defaultValue((Object)true).add().property().name("migrationStrategy").type("string").helpText("Strategy to use to migrate database. Valid values are update, manual and validate. Update will automatically migrate the database schema. Manual will export the required changes to a file with SQL commands that you can manually execute on the database. Validate will simply check if the database is up-to-date.").options(new String[]{"update", "manual", "validate"}).defaultValue((Object)"update").add().property().name("migrationExport").type("string").helpText("Path for where to write manual database initialization/migration file.").add().build();
    }

    @Override
    protected EntityManagerFactory getEntityManagerFactory() {
        InjectableInstance instance = Arc.container().select(EntityManagerFactory.class, new Annotation[0]);
        if (instance.isResolvable()) {
            return (EntityManagerFactory)instance.get();
        }
        return this.getEntityManagerFactory("keycloak-default").orElseThrow(() -> new IllegalStateException("Failed to resolve the default entity manager factory"));
    }

    public Map<String, String> getOperationalInfo() {
        return this.operationalInfo;
    }

    public int order() {
        return 100;
    }

    private MigrationStrategy getMigrationStrategy() {
        String migrationStrategy = this.config.get("migrationStrategy");
        if (migrationStrategy == null) {
            migrationStrategy = this.config.get("databaseSchema");
        }
        if (migrationStrategy != null) {
            return MigrationStrategy.valueOf(migrationStrategy.toUpperCase());
        }
        return MigrationStrategy.UPDATE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSchema(KeycloakSession session) {
        ExportImportManager exportImportManager = new ExportImportManager(session);
        if (!(Config.getProvider((String)"realm") != null && !"jpa".equals(Config.getProvider((String)"realm")) || Config.getProvider((String)"client") != null && !"jpa".equals(Config.getProvider((String)"client")) || Config.getProvider((String)"clientScope") != null && !"jpa".equals(Config.getProvider((String)"clientScope")))) {
            logger.debug((Object)"Calling migrateModel");
            this.migrateModel(session);
        }
        DBLockManager dbLockManager = new DBLockManager(session);
        dbLockManager.checkForcedUnlock();
        DBLockProvider dbLock = dbLockManager.getDBLock();
        dbLock.waitForLock(DBLockProvider.Namespace.KEYCLOAK_BOOT);
        try {
            this.createMasterRealm(exportImportManager);
        }
        finally {
            dbLock.releaseLock();
        }
        if (exportImportManager.isRunExport()) {
            exportImportManager.runExport();
            Quarkus.asyncExit();
        }
    }

    private ExportImportManager createMasterRealm(ExportImportManager exportImportManager) {
        logger.debug((Object)"bootstrap");
        try (KeycloakSession session = this.factory.create();){
            session.getTransactionManager().begin();
            if (this.xaEnabled.booleanValue()) {
                JtaTransactionManagerLookup lookup = (JtaTransactionManagerLookup)this.factory.getProviderFactory(JtaTransactionManagerLookup.class);
                try {
                    Transaction transaction = lookup.getTransactionManager().getTransaction();
                    logger.debugv("bootstrap current transaction? {0}", (Object)(transaction != null ? 1 : 0));
                    if (transaction != null) {
                        logger.debugv("bootstrap current transaction status? {0}", (Object)transaction.getStatus());
                    }
                }
                catch (SystemException e) {
                    throw new RuntimeException(e);
                }
            }
            ApplianceBootstrap applianceBootstrap = new ApplianceBootstrap(session);
            boolean createMasterRealm = applianceBootstrap.isNewInstall();
            if (exportImportManager.isRunImport() && exportImportManager.isImportMasterIncluded()) {
                createMasterRealm = false;
            }
            if (createMasterRealm) {
                applianceBootstrap.createMasterRealm();
            }
            session.getTransactionManager().commit();
        }
        if (exportImportManager.isRunImport()) {
            exportImportManager.runImport();
            Quarkus.asyncExit();
        } else {
            this.importRealms();
        }
        this.importAddUser();
        return exportImportManager;
    }

    private void migrateModel(KeycloakSession session) {
        MigrationModelManager.migrate((KeycloakSession)session);
    }

    private void importRealms() {
        String files = System.getProperty("keycloak.import");
        if (files != null) {
            StringTokenizer tokenizer = new StringTokenizer(files, ",");
            while (tokenizer.hasMoreTokens()) {
                RealmRepresentation rep;
                String file = tokenizer.nextToken().trim();
                try {
                    rep = (RealmRepresentation)JsonSerialization.readValue((String)StringPropertyReplacer.replaceProperties((String)Files.readString(Paths.get(file, new String[0])), (StringPropertyReplacer.PropertyResolver)new StringPropertyReplacer.PropertyResolver(){

                        public String resolve(String property) {
                            return Optional.ofNullable(System.getenv(property)).orElse(null);
                        }
                    }), RealmRepresentation.class);
                }
                catch (Exception cause) {
                    throw new RuntimeException("Failed to parse realm configuration file: " + file, cause);
                }
                this.importRealm(rep, "file " + file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importRealm(RealmRepresentation rep, String from) {
        boolean exists = false;
        try (KeycloakSession session = this.factory.create();){
            session.getTransactionManager().begin();
            try {
                RealmManager manager = new RealmManager(session);
                if (rep.getId() != null && manager.getRealm(rep.getId()) != null) {
                    ServicesLogger.LOGGER.realmExists(rep.getRealm(), from);
                    exists = true;
                }
                if (!exists && manager.getRealmByName(rep.getRealm()) != null) {
                    ServicesLogger.LOGGER.realmExists(rep.getRealm(), from);
                    exists = true;
                }
                if (!exists) {
                    RealmModel realm = manager.importRealm(rep);
                    ServicesLogger.LOGGER.importedRealm(realm.getName(), from);
                }
                session.getTransactionManager().commit();
            }
            catch (Throwable cause) {
                session.getTransactionManager().rollback();
                if (!exists) {
                    throw new RuntimeException("Failed to import realm: " + rep.getRealm(), cause);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importAddUser() {
        File addUserFile;
        String configDir = System.getProperty("jboss.server.config.dir");
        if (configDir != null && (addUserFile = new File(configDir + File.separator + "keycloak-add-user.json")).isFile()) {
            List realms;
            ServicesLogger.LOGGER.imprtingUsersFrom((Object)addUserFile);
            try {
                realms = (List)JsonSerialization.readValue((InputStream)new FileInputStream(addUserFile), (TypeReference)new TypeReference<List<RealmRepresentation>>(){});
            }
            catch (IOException e) {
                ServicesLogger.LOGGER.failedToLoadUsers((Throwable)e);
                return;
            }
            for (RealmRepresentation realmRep : realms) {
                for (UserRepresentation userRep : realmRep.getUsers()) {
                    try (KeycloakSession session = this.factory.create();){
                        UserProvider users;
                        session.getTransactionManager().begin();
                        RealmModel realm = session.realms().getRealmByName(realmRep.getRealm());
                        if (realm == null) {
                            ServicesLogger.LOGGER.addUserFailedRealmNotFound(userRep.getUsername(), realmRep.getRealm());
                        }
                        if ((users = session.users()).getUserByUsername(realm, userRep.getUsername()) != null) {
                            ServicesLogger.LOGGER.notCreatingExistingUser(userRep.getUsername());
                        } else {
                            UserModel user = users.addUser(realm, userRep.getUsername());
                            user.setEnabled(userRep.isEnabled().booleanValue());
                            RepresentationToModel.createCredentials((UserRepresentation)userRep, (KeycloakSession)session, (RealmModel)realm, (UserModel)user, (boolean)false);
                            RepresentationToModel.createRoleMappings((UserRepresentation)userRep, (UserModel)user, (RealmModel)realm);
                            ServicesLogger.LOGGER.addUserSuccess(userRep.getUsername(), realmRep.getRealm());
                        }
                        session.getTransactionManager().commit();
                    }
                }
            }
            if (!addUserFile.delete()) {
                ServicesLogger.LOGGER.failedToDeleteFile(addUserFile.getAbsolutePath());
            }
        }
    }

    private String getSchema(String schema) {
        return schema == null ? "" : schema + ".";
    }

    private File getDatabaseUpdateFile() {
        String databaseUpdateFile = this.config.get("migrationExport", "keycloak-database-update.sql");
        return new File(databaseUpdateFile);
    }

    private void createOperationalInfo(Connection connection) {
        try {
            this.operationalInfo = new LinkedHashMap<String, String>();
            DatabaseMetaData md = connection.getMetaData();
            this.operationalInfo.put("databaseUrl", md.getURL());
            this.operationalInfo.put("databaseUser", md.getUserName());
            this.operationalInfo.put("databaseProduct", md.getDatabaseProductName() + " " + md.getDatabaseProductVersion());
            this.operationalInfo.put("databaseDriver", md.getDriverName() + " " + md.getDriverVersion());
            logger.debugf("Database info: %s", (Object)this.operationalInfo.toString());
        }
        catch (SQLException e) {
            logger.warn((Object)("Unable to prepare operational info due database exception: " + e.getMessage()));
        }
    }

    private boolean createOrUpdateSchema(String schema, String version, Connection connection, KeycloakSession session) {
        MigrationStrategy strategy = this.getMigrationStrategy();
        boolean initializeEmpty = this.config.getBoolean("initializeEmpty", Boolean.valueOf(true));
        File databaseUpdateFile = this.getDatabaseUpdateFile();
        JpaUpdaterProvider updater = (JpaUpdaterProvider)session.getProvider(JpaUpdaterProvider.class);
        boolean requiresMigration = version == null || !version.equals(new ModelVersion(Version.VERSION_KEYCLOAK).toString());
        session.setAttribute("VERIFY_AND_RUN_MASTER_CHANGELOG", (Object)requiresMigration);
        JpaUpdaterProvider.Status status = updater.validate(connection, schema);
        if (status == JpaUpdaterProvider.Status.VALID) {
            logger.debug((Object)"Database is up-to-date");
        } else if (status == JpaUpdaterProvider.Status.EMPTY) {
            if (initializeEmpty) {
                this.update(connection, schema, session, updater);
            } else {
                switch (strategy) {
                    case UPDATE: {
                        this.update(connection, schema, session, updater);
                        break;
                    }
                    case MANUAL: {
                        this.export(connection, schema, databaseUpdateFile, session, updater);
                        throw new ServerStartupError("Database not initialized, please initialize database with " + databaseUpdateFile.getAbsolutePath(), false);
                    }
                    case VALIDATE: {
                        throw new ServerStartupError("Database not initialized, please enable database initialization", false);
                    }
                }
            }
        } else {
            switch (strategy) {
                case UPDATE: {
                    this.update(connection, schema, session, updater);
                    break;
                }
                case MANUAL: {
                    this.export(connection, schema, databaseUpdateFile, session, updater);
                    throw new ServerStartupError("Database not up-to-date, please migrate database with " + databaseUpdateFile.getAbsolutePath(), false);
                }
                case VALIDATE: {
                    throw new ServerStartupError("Database not up-to-date, please enable database migration", false);
                }
            }
        }
        return requiresMigration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(Connection connection, String schema, KeycloakSession session, JpaUpdaterProvider updater) {
        DBLockManager dbLockManager = new DBLockManager(session);
        DBLockProvider dbLock2 = dbLockManager.getDBLock();
        dbLock2.waitForLock(DBLockProvider.Namespace.DATABASE);
        try {
            updater.update(connection, schema);
        }
        finally {
            dbLock2.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void export(Connection connection, String schema, File databaseUpdateFile, KeycloakSession session, JpaUpdaterProvider updater) {
        DBLockManager dbLockManager = new DBLockManager(session);
        DBLockProvider dbLock2 = dbLockManager.getDBLock();
        dbLock2.waitForLock(DBLockProvider.Namespace.DATABASE);
        try {
            updater.export(connection, schema, databaseUpdateFile);
        }
        finally {
            dbLock2.releaseLock();
        }
    }

    static enum MigrationStrategy {
        UPDATE,
        VALIDATE,
        MANUAL;

    }
}

