/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.webauthn4j.data.AuthenticatorAttachment;
import com.webauthn4j.data.ResidentKeyRequirement;
import com.webauthn4j.data.UserVerificationRequirement;
import java.io.Serializable;
import java.util.Objects;

public class AuthenticatorSelectionCriteria
implements Serializable {
    private final AuthenticatorAttachment authenticatorAttachment;
    private boolean requireResidentKey = false;
    private ResidentKeyRequirement residentKey = null;
    private UserVerificationRequirement userVerification = UserVerificationRequirement.PREFERRED;

    @JsonCreator
    public AuthenticatorSelectionCriteria(@JsonProperty(value="authenticatorAttachment") AuthenticatorAttachment authenticatorAttachment, @JsonProperty(value="requireResidentKey") boolean requireResidentKey, @JsonProperty(value="residentKey") ResidentKeyRequirement residentKey, @JsonProperty(value="userVerification") UserVerificationRequirement userVerification) {
        this.authenticatorAttachment = authenticatorAttachment;
        this.requireResidentKey = requireResidentKey;
        this.residentKey = residentKey;
        this.userVerification = userVerification;
    }

    public AuthenticatorSelectionCriteria(AuthenticatorAttachment authenticatorAttachment, ResidentKeyRequirement residentKey, UserVerificationRequirement userVerification) {
        this(authenticatorAttachment, false, residentKey, userVerification);
    }

    public AuthenticatorSelectionCriteria(AuthenticatorAttachment authenticatorAttachment, boolean requireResidentKey, UserVerificationRequirement userVerification) {
        this(authenticatorAttachment, requireResidentKey, null, userVerification);
    }

    public AuthenticatorAttachment getAuthenticatorAttachment() {
        return this.authenticatorAttachment;
    }

    public boolean isRequireResidentKey() {
        return this.requireResidentKey;
    }

    public ResidentKeyRequirement getResidentKey() {
        return this.residentKey;
    }

    public UserVerificationRequirement getUserVerification() {
        return this.userVerification;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticatorSelectionCriteria that = (AuthenticatorSelectionCriteria)o;
        return this.requireResidentKey == that.requireResidentKey && this.authenticatorAttachment == that.authenticatorAttachment && this.residentKey == that.residentKey && this.userVerification == that.userVerification;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authenticatorAttachment, this.requireResidentKey, this.residentKey, this.userVerification});
    }
}

