/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.scripting;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.scripting.DefaultScriptingProvider;
import org.keycloak.scripting.ScriptingProvider;
import org.keycloak.scripting.ScriptingProviderFactory;

public class DefaultScriptingProviderFactory
implements ScriptingProviderFactory {
    private static final Logger logger = Logger.getLogger(DefaultScriptingProviderFactory.class);
    static final String ID = "script-based-auth";
    private ScriptEngineManager scriptEngineManager;
    private boolean enableScriptEngineCache;
    private Map<String, ScriptEngine> scriptEngineCache;

    public ScriptingProvider create(KeycloakSession session) {
        this.lazyInit();
        return new DefaultScriptingProvider(this);
    }

    public void init(Config.Scope config) {
        this.enableScriptEngineCache = config.getBoolean("enable-script-engine-cache", Boolean.valueOf(true));
        logger.debugf("Enable script engine cache: %b", (Object)this.enableScriptEngineCache);
    }

    ScriptEngineManager getScriptEngineManager() {
        return this.scriptEngineManager;
    }

    boolean isEnableScriptEngineCache() {
        return this.enableScriptEngineCache;
    }

    Map<String, ScriptEngine> getScriptEngineCache() {
        return this.scriptEngineCache;
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return ID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInit() {
        if (this.scriptEngineManager == null) {
            DefaultScriptingProviderFactory defaultScriptingProviderFactory = this;
            synchronized (defaultScriptingProviderFactory) {
                if (this.scriptEngineManager == null) {
                    this.scriptEngineManager = new ScriptEngineManager();
                    if (this.enableScriptEngineCache) {
                        this.scriptEngineCache = new ConcurrentHashMap<String, ScriptEngine>();
                    }
                }
            }
        }
    }
}

