/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.okhttp;

import com.openshift.internal.restclient.okhttp.IChallangeHandler;
import com.openshift.restclient.authorization.IAuthorizationContext;
import com.openshift.restclient.utils.Base64Coder;
import okhttp3.Headers;
import okhttp3.Request;
import org.apache.commons.lang.StringUtils;

public class BasicChallangeHandler
implements IChallangeHandler {
    private IAuthorizationContext context;

    public BasicChallangeHandler(IAuthorizationContext context) {
        this.context = context;
    }

    @Override
    public boolean canHandle(Headers headers) {
        return "Basic".equalsIgnoreCase(headers.get("Www-Authenticate"));
    }

    @Override
    public Request.Builder handleChallange(Request.Builder builder) {
        StringBuilder value = new StringBuilder();
        if (StringUtils.isNotBlank((String)this.context.getUserName())) {
            value.append(this.context.getUserName()).append(":");
        }
        if (StringUtils.isNotBlank((String)this.context.getPassword())) {
            value.append(this.context.getPassword());
        }
        return builder.header("Authorization", "Basic " + Base64Coder.encode(value.toString()));
    }
}

