/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.remotestore;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Retry;
import org.keycloak.connections.infinispan.InfinispanUtil;
import org.keycloak.connections.infinispan.TopologyInfo;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.sessions.infinispan.changes.MergedUpdate;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.changes.SessionUpdateTask;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;

public class RemoteCacheInvoker {
    public static final Logger logger = Logger.getLogger(RemoteCacheInvoker.class);
    private final Map<String, RemoteCacheContext> remoteCaches = new HashMap<String, RemoteCacheContext>();

    public void addRemoteCache(String cacheName, RemoteCache remoteCache, MaxIdleTimeLoader maxIdleLoader) {
        RemoteCacheContext ctx = new RemoteCacheContext(remoteCache, maxIdleLoader);
        this.remoteCaches.put(cacheName, ctx);
    }

    public Set<String> getRemoteCacheNames() {
        return Collections.unmodifiableSet(this.remoteCaches.keySet());
    }

    public <K, V extends SessionEntity> void runTask(KeycloakSession kcSession, RealmModel realm, String cacheName, K key, MergedUpdate<V> task, SessionEntityWrapper<V> sessionWrapper) {
        RemoteCacheContext context = this.remoteCaches.get(cacheName);
        if (context == null) {
            return;
        }
        V session = sessionWrapper.getEntity();
        SessionUpdateTask.CacheOperation operation = task.getOperation(session);
        SessionUpdateTask.CrossDCMessageStatus status = task.getCrossDCMessageStatus(sessionWrapper);
        if (status == SessionUpdateTask.CrossDCMessageStatus.NOT_NEEDED) {
            if (logger.isTraceEnabled()) {
                logger.tracef("Skip writing to remoteCache for entity '%s' of cache '%s' and operation '%s'", key, (Object)cacheName, (Object)operation);
            }
            return;
        }
        long loadedMaxIdleTimeMs = context.maxIdleTimeLoader.getMaxIdleTimeMs(realm);
        long maxIdleTimeMs = loadedMaxIdleTimeMs + 1800000L;
        if (logger.isTraceEnabled()) {
            logger.tracef("Running task '%s' on remote cache '%s' . Key is '%s'", (Object)operation, (Object)cacheName, key);
        }
        TopologyInfo topology = InfinispanUtil.getTopologyInfo(kcSession);
        Retry.executeWithBackoff(iteration -> {
            try {
                this.runOnRemoteCache(topology, context.remoteCache, maxIdleTimeMs, key, task, sessionWrapper);
            }
            catch (HotRodClientException re) {
                if (logger.isDebugEnabled()) {
                    logger.debugf((Throwable)re, "Failed running task '%s' on remote cache '%s' . Key: '%s', iteration '%s'. Will try to retry the task", new Object[]{operation, cacheName, key, iteration});
                }
                throw re;
            }
        }, (int)10, (int)10);
    }

    private <K, V extends SessionEntity> void runOnRemoteCache(TopologyInfo topology, RemoteCache<K, SessionEntityWrapper<V>> remoteCache, long maxIdleMs, K key, MergedUpdate<V> task, SessionEntityWrapper<V> sessionWrapper) {
        V session = sessionWrapper.getEntity();
        SessionUpdateTask.CacheOperation operation = task.getOperation(session);
        switch (operation) {
            case REMOVE: {
                remoteCache.remove(key);
                break;
            }
            case ADD: {
                remoteCache.put(key, sessionWrapper.forTransport(), InfinispanUtil.toHotrodTimeMs(remoteCache, task.getLifespanMs()), TimeUnit.MILLISECONDS, InfinispanUtil.toHotrodTimeMs(remoteCache, maxIdleMs), TimeUnit.MILLISECONDS);
                break;
            }
            case ADD_IF_ABSENT: {
                SessionEntityWrapper existing = (SessionEntityWrapper)remoteCache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).putIfAbsent(key, sessionWrapper.forTransport(), -1L, TimeUnit.MILLISECONDS, InfinispanUtil.toHotrodTimeMs(remoteCache, maxIdleMs), TimeUnit.MILLISECONDS);
                if (existing == null) break;
                logger.debugf("Existing entity in remote cache for key: %s . Will update it", key);
                this.replace(topology, remoteCache, task.getLifespanMs(), maxIdleMs, key, task);
                break;
            }
            case REPLACE: {
                this.replace(topology, remoteCache, task.getLifespanMs(), maxIdleMs, key, task);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported state " + (Object)((Object)operation));
            }
        }
    }

    private <K, V extends SessionEntity> void replace(TopologyInfo topology, RemoteCache<K, SessionEntityWrapper<V>> remoteCache, long lifespanMs, long maxIdleMs, K key, SessionUpdateTask<V> task) {
        lifespanMs = InfinispanUtil.toHotrodTimeMs(remoteCache, lifespanMs);
        maxIdleMs = InfinispanUtil.toHotrodTimeMs(remoteCache, maxIdleMs);
        boolean replaced = false;
        int replaceIteration = 0;
        while (!replaced && replaceIteration < 25) {
            ++replaceIteration;
            MetadataValue versioned = remoteCache.getWithMetadata(key);
            if (versioned == null) {
                logger.warnf("Not found entity to replace for key '%s'", key);
                return;
            }
            SessionEntityWrapper sessionWrapper = (SessionEntityWrapper)versioned.getValue();
            Object session = sessionWrapper.getEntity();
            task.runUpdate(session);
            if (logger.isTraceEnabled()) {
                logger.tracef("%s: Before replaceWithVersion. Entity to write version %d: %s", (Object)this.logTopologyData(topology, replaceIteration), (Object)versioned.getVersion(), session);
            }
            if (!(replaced = remoteCache.replaceWithVersion(key, SessionEntityWrapper.forTransport(session), versioned.getVersion(), lifespanMs, TimeUnit.MILLISECONDS, maxIdleMs, TimeUnit.MILLISECONDS))) {
                logger.debugf("%s: Failed to replace entity '%s' version %d. Will retry again", (Object)this.logTopologyData(topology, replaceIteration), key, (Object)versioned.getVersion());
                continue;
            }
            if (!logger.isTraceEnabled()) continue;
            logger.tracef("%s: Replaced entity version %d in remote cache: %s", (Object)this.logTopologyData(topology, replaceIteration), (Object)versioned.getVersion(), session);
        }
        if (!replaced) {
            logger.warnf("Failed to replace entity '%s' in remote cache '%s'", key, (Object)remoteCache.getName());
        }
    }

    private String logTopologyData(TopologyInfo topology, int iteration) {
        return topology.toString() + ", replaceIteration: " + iteration;
    }

    @FunctionalInterface
    public static interface MaxIdleTimeLoader {
        public long getMaxIdleTimeMs(RealmModel var1);
    }

    private static class RemoteCacheContext {
        private final RemoteCache remoteCache;
        private final MaxIdleTimeLoader maxIdleTimeLoader;

        public RemoteCacheContext(RemoteCache remoteCache, MaxIdleTimeLoader maxIdleLoader) {
            this.remoteCache = remoteCache;
            this.maxIdleTimeLoader = maxIdleLoader;
        }
    }
}

