/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.cli.command;

import java.io.File;
import java.util.Optional;
import org.keycloak.quarkus.runtime.Environment;
import picocli.CommandLine;

public final class ImportRealmMixin {
    public static final String IMPORT_REALM = "--import-realm";
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;

    @CommandLine.Option(names={"--import-realm"}, description={"Import realms during startup by reading any realm configuration file from the 'data/import' directory."}, paramLabel="none", arity="0")
    public void setImportRealm(String realmFiles) {
        StringBuilder filesToImport = new StringBuilder(Optional.ofNullable(realmFiles).orElse(""));
        if (filesToImport.length() > 0) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "Instead of manually specifying the files to import, just copy them to the 'data/import' directory.");
        }
        File importDir = Environment.getHomePath().resolve("data").resolve("import").toFile();
        if (importDir.exists()) {
            for (File realmFile : importDir.listFiles()) {
                filesToImport.append(realmFile.getAbsolutePath()).append(",");
            }
        }
        System.setProperty("keycloak.import", filesToImport.toString());
    }
}

