/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.CompletedStage;
import io.quarkus.qute.Expression;
import io.quarkus.qute.Expressions;
import io.quarkus.qute.ImmutableList;
import io.quarkus.qute.Mapper;
import io.quarkus.qute.Parameter;
import io.quarkus.qute.ResolutionContext;
import io.quarkus.qute.ResultNode;
import io.quarkus.qute.Results;
import io.quarkus.qute.Scope;
import io.quarkus.qute.SectionBlock;
import io.quarkus.qute.SectionHelper;
import io.quarkus.qute.SectionHelperFactory;
import io.quarkus.qute.TemplateException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class LoopSectionHelper
implements SectionHelper {
    private static final String DEFAULT_ALIAS = "it";
    private static final String ELSE = "else";
    private static final String ALIAS = "alias";
    private static final String ITERABLE = "iterable";
    private final String alias;
    private final String metadataPrefix;
    private final Expression iterable;
    private final SectionBlock elseBlock;

    LoopSectionHelper(SectionHelperFactory.SectionInitContext context, String metadataPrefix) {
        this.alias = context.getParameterOrDefault(ALIAS, DEFAULT_ALIAS);
        this.metadataPrefix = Factory.prefixValue(this.alias, metadataPrefix);
        this.iterable = Objects.requireNonNull(context.getExpression(ITERABLE));
        this.elseBlock = context.getBlock(ELSE);
    }

    @Override
    public CompletionStage<ResultNode> resolve(SectionHelper.SectionResolutionContext context) {
        return context.resolutionContext().evaluate(this.iterable).thenCompose(it -> {
            if (it == null) {
                throw new TemplateException(String.format("Iteration error in template [%s] on line %s: {%s} resolved to null, use {%<s.orEmpty} to ignore this error", this.iterable.getOrigin().getTemplateId(), this.iterable.getOrigin().getLine(), this.iterable.toOriginalString()));
            }
            ArrayList<CompletionStage<ResultNode>> results = new ArrayList<CompletionStage<ResultNode>>(LoopSectionHelper.extractSize(it));
            Iterator<?> iterator = this.extractIterator(it);
            int idx = 0;
            while (iterator.hasNext()) {
                results.add(this.nextElement(iterator.next(), idx++, iterator.hasNext(), context));
            }
            if (results.isEmpty()) {
                if (this.elseBlock != null) {
                    return context.execute(this.elseBlock, context.resolutionContext());
                }
                return ResultNode.NOOP;
            }
            if (results.size() == 1) {
                return (CompletionStage)results.get(0);
            }
            return Results.process(results);
        });
    }

    private static int extractSize(Object it) {
        if (it instanceof Collection) {
            return ((Collection)it).size();
        }
        if (it instanceof Map) {
            return ((Map)it).size();
        }
        if (it.getClass().isArray()) {
            return Array.getLength(it);
        }
        if (it instanceof Integer) {
            return (Integer)it;
        }
        return 10;
    }

    private Iterator<?> extractIterator(Object it) {
        if (it instanceof Iterable) {
            return ((Iterable)it).iterator();
        }
        if (it instanceof Iterator) {
            return (Iterator)it;
        }
        if (it instanceof Map) {
            return ((Map)it).entrySet().iterator();
        }
        if (it instanceof Stream) {
            return ((Stream)((Stream)it).sequential()).iterator();
        }
        if (it instanceof Integer) {
            return IntStream.rangeClosed(1, (Integer)it).iterator();
        }
        if (it.getClass().isArray()) {
            int length = Array.getLength(it);
            ArrayList<Object> elements = new ArrayList<Object>(length);
            for (int i = 0; i < length; ++i) {
                elements.add(Array.get(it, i));
            }
            return elements.iterator();
        }
        String msg = Results.isNotFound(it) ? String.format("Iteration error in template [%s] on line %s: {%s} not found, use {%<s.orEmpty} to ignore this error", this.iterable.getOrigin().getTemplateId(), this.iterable.getOrigin().getLine(), this.iterable.toOriginalString()) : String.format("Iteration error in template [%s] on line %s: {%s} resolved to [%s] which is not iterable", this.iterable.getOrigin().getTemplateId(), this.iterable.getOrigin().getLine(), this.iterable.toOriginalString(), it.getClass().getName());
        throw new TemplateException(msg);
    }

    CompletionStage<ResultNode> nextElement(Object element, int index, boolean hasNext, SectionHelper.SectionResolutionContext context) {
        ResolutionContext child = context.resolutionContext().createChild(new IterationElement(this.alias, this.metadataPrefix, element, index, hasNext), null);
        return context.execute(child);
    }

    static class IterationElement
    implements Mapper {
        static final CompletedStage<Object> EVEN = CompletedStage.of("even");
        static final CompletedStage<Object> ODD = CompletedStage.of("odd");
        final String alias;
        final String metadataPrefix;
        final CompletedStage<Object> element;
        final int index;
        final boolean hasNext;

        public IterationElement(String alias, String metadataPrefix, Object element, int index, boolean hasNext) {
            this.alias = alias;
            this.metadataPrefix = metadataPrefix;
            this.element = CompletedStage.of(element);
            this.index = index;
            this.hasNext = hasNext;
        }

        @Override
        public CompletionStage<Object> getAsync(String key) {
            if (this.alias.equals(key)) {
                return this.element;
            }
            if (this.metadataPrefix != null) {
                if (key.startsWith(this.metadataPrefix)) {
                    key = key.substring(this.metadataPrefix.length(), key.length());
                } else {
                    return Results.notFound(key);
                }
            }
            switch (key) {
                case "count": {
                    return CompletedStage.of(this.index + 1);
                }
                case "index": {
                    return CompletedStage.of(this.index);
                }
                case "indexParity": {
                    return this.index % 2 != 0 ? EVEN : ODD;
                }
                case "hasNext": {
                    return this.hasNext ? Results.TRUE : Results.FALSE;
                }
                case "isLast": {
                    return this.hasNext ? Results.FALSE : Results.TRUE;
                }
                case "isFirst": {
                    return this.index == 0 ? Results.TRUE : Results.FALSE;
                }
                case "isOdd": 
                case "odd": {
                    return this.index % 2 == 0 ? Results.TRUE : Results.FALSE;
                }
                case "isEven": 
                case "even": {
                    return this.index % 2 != 0 ? Results.TRUE : Results.FALSE;
                }
            }
            return Results.notFound(key);
        }
    }

    public static class Factory
    implements SectionHelperFactory<LoopSectionHelper> {
        public static final String ITERATION_METADATA_PREFIX_ALIAS_QM = "<alias?>";
        public static final String ITERATION_METADATA_PREFIX_ALIAS_UNDERSCORE = "<alias_>";
        public static final String ITERATION_METADATA_PREFIX_NONE = "<none>";
        public static final String HINT_ELEMENT = "<loop-element>";
        public static final String HINT_PREFIX = "<loop#";
        private static final String IN = "in";
        private final String metadataPrefix;

        public Factory() {
            this(ITERATION_METADATA_PREFIX_ALIAS_UNDERSCORE);
        }

        public Factory(String metadataPrefix) {
            Objects.requireNonNull(metadataPrefix, "Iteration metadata must not be null");
            this.metadataPrefix = metadataPrefix.isBlank() || metadataPrefix.equals(ITERATION_METADATA_PREFIX_NONE) ? null : metadataPrefix;
        }

        @Override
        public List<String> getDefaultAliases() {
            return ImmutableList.of("for", "each");
        }

        @Override
        public SectionHelperFactory.ParametersInfo getParameters() {
            return SectionHelperFactory.ParametersInfo.builder().addParameter(LoopSectionHelper.ALIAS, "$empty$").addParameter(IN, "$empty$").addParameter(Parameter.builder(LoopSectionHelper.ITERABLE).optional()).build();
        }

        @Override
        public List<String> getBlockLabels() {
            return Collections.singletonList(LoopSectionHelper.ELSE);
        }

        @Override
        public LoopSectionHelper initialize(SectionHelperFactory.SectionInitContext context) {
            return new LoopSectionHelper(context, this.metadataPrefix);
        }

        @Override
        public Scope initializeBlock(Scope previousScope, SectionHelperFactory.BlockInfo block) {
            if (block.getLabel().equals("$main")) {
                String iterable = block.getParameters().get(LoopSectionHelper.ITERABLE);
                if (iterable == null) {
                    iterable = "this";
                }
                previousScope.setLastPartHint(HINT_ELEMENT);
                Expression iterableExpr = block.addExpression(LoopSectionHelper.ITERABLE, iterable);
                previousScope.setLastPartHint(null);
                String alias = block.getParameters().get(LoopSectionHelper.ALIAS);
                if (iterableExpr.hasTypeInfo()) {
                    alias = alias.equals("$empty$") ? LoopSectionHelper.DEFAULT_ALIAS : alias;
                    Scope newScope = new Scope(previousScope);
                    newScope.putBinding(alias, alias + HINT_PREFIX + iterableExpr.getGeneratedId() + ">");
                    String prefix = Factory.prefixValue(alias, this.metadataPrefix);
                    this.newScopeBinding(newScope, prefix, "count", Integer.class.getName());
                    this.newScopeBinding(newScope, prefix, "index", Integer.class.getName());
                    this.newScopeBinding(newScope, prefix, "indexParity", String.class.getName());
                    this.newScopeBinding(newScope, prefix, "hasNext", Boolean.class.getName());
                    this.newScopeBinding(newScope, prefix, "isLast", Boolean.class.getName());
                    this.newScopeBinding(newScope, prefix, "isFirst", Boolean.class.getName());
                    this.newScopeBinding(newScope, prefix, "odd", Boolean.class.getName());
                    this.newScopeBinding(newScope, prefix, "isOdd", Boolean.class.getName());
                    this.newScopeBinding(newScope, prefix, "even", Boolean.class.getName());
                    this.newScopeBinding(newScope, prefix, "isEven", Boolean.class.getName());
                    return newScope;
                }
                Scope newScope = new Scope(previousScope);
                newScope.putBinding(alias, null);
                return newScope;
            }
            return previousScope;
        }

        private void newScopeBinding(Scope scope, String prefix, String name, String typeName) {
            scope.putBinding((String)(prefix != null ? prefix + name : name), Expressions.typeInfoFrom(typeName));
        }

        static String prefixValue(String alias, String metadataPrefix) {
            if (metadataPrefix == null || ITERATION_METADATA_PREFIX_NONE.equals(metadataPrefix)) {
                return null;
            }
            if (ITERATION_METADATA_PREFIX_ALIAS_UNDERSCORE.equals(metadataPrefix)) {
                return alias + "_";
            }
            if (ITERATION_METADATA_PREFIX_ALIAS_QM.equals(metadataPrefix)) {
                return alias + "?";
            }
            return metadataPrefix;
        }
    }
}

