/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.ws.rs.core.Application;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.common.util.Resteasy;
import org.keycloak.config.ConfigProviderFactory;
import org.keycloak.exportimport.ExportImportManager;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakSessionTask;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.models.dblock.DBLockManager;
import org.keycloak.models.dblock.DBLockProvider;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.PostMigrationEvent;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.platform.Platform;
import org.keycloak.platform.PlatformProvider;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.services.DefaultKeycloakSessionFactory;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.error.KcUnrecognizedPropertyExceptionHandler;
import org.keycloak.services.error.KeycloakErrorHandler;
import org.keycloak.services.filters.KeycloakSecurityHeadersFilter;
import org.keycloak.services.managers.ApplianceBootstrap;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.managers.UserStorageSyncManager;
import org.keycloak.services.resources.JsResource;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.services.resources.RobotsResource;
import org.keycloak.services.resources.ThemeResource;
import org.keycloak.services.resources.WelcomeResource;
import org.keycloak.services.resources.admin.AdminRoot;
import org.keycloak.services.scheduled.ClearExpiredClientInitialAccessTokens;
import org.keycloak.services.scheduled.ClearExpiredEvents;
import org.keycloak.services.scheduled.ClearExpiredUserSessions;
import org.keycloak.services.scheduled.ClusterAwareScheduledTaskRunner;
import org.keycloak.services.scheduled.ScheduledTaskRunner;
import org.keycloak.services.util.ObjectMapperResolver;
import org.keycloak.timer.ScheduledTask;
import org.keycloak.timer.TimerProvider;
import org.keycloak.transaction.JtaTransactionManagerLookup;
import org.keycloak.util.JsonSerialization;

public class KeycloakApplication
extends Application {
    public static final AtomicBoolean BOOTSTRAP_ADMIN_USER = new AtomicBoolean(false);
    private static final Logger logger = Logger.getLogger(KeycloakApplication.class);
    protected final PlatformProvider platform = Platform.getPlatform();
    protected Set<Object> singletons = new HashSet<Object>();
    protected Set<Class<?>> classes = new HashSet();
    protected static KeycloakSessionFactory sessionFactory;

    public KeycloakApplication() {
        try {
            logger.debugv("PlatformProvider: {0}", (Object)this.platform.getClass().getName());
            logger.debugv("RestEasy provider: {0}", (Object)Resteasy.getProvider().getClass().getName());
            this.loadConfig();
            this.singletons.add(new RobotsResource());
            this.singletons.add(new RealmsResource());
            this.singletons.add(new AdminRoot());
            this.classes.add(ThemeResource.class);
            this.classes.add(JsResource.class);
            this.classes.add(KeycloakSecurityHeadersFilter.class);
            this.classes.add(KeycloakErrorHandler.class);
            this.classes.add(KcUnrecognizedPropertyExceptionHandler.class);
            this.singletons.add(new ObjectMapperResolver());
            this.singletons.add(new WelcomeResource());
            this.platform.onStartup(this::startup);
            this.platform.onShutdown(this::shutdown);
        }
        catch (Throwable t) {
            this.platform.exit(t);
        }
    }

    protected void startup() {
        sessionFactory = KeycloakApplication.createSessionFactory();
        final ExportImportManager[] exportImportManager = new ExportImportManager[1];
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(KeycloakSession session) {
                DBLockManager dbLockManager = new DBLockManager(session);
                dbLockManager.checkForcedUnlock();
                DBLockProvider dbLock = dbLockManager.getDBLock();
                dbLock.waitForLock(DBLockProvider.Namespace.KEYCLOAK_BOOT);
                try {
                    exportImportManager[0] = KeycloakApplication.this.bootstrap();
                }
                finally {
                    dbLock.releaseLock();
                }
            }
        });
        if (exportImportManager[0].isRunExport()) {
            exportImportManager[0].runExport();
        }
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

            public void run(KeycloakSession session) {
                boolean shouldBootstrapAdmin = new ApplianceBootstrap(session).isNoMasterUser();
                BOOTSTRAP_ADMIN_USER.set(shouldBootstrapAdmin);
            }
        });
        sessionFactory.publish((ProviderEvent)new PostMigrationEvent());
        KeycloakApplication.setupScheduledTasks(sessionFactory);
    }

    protected void shutdown() {
        if (sessionFactory != null) {
            sessionFactory.close();
        }
    }

    protected ExportImportManager bootstrap() {
        final ExportImportManager[] exportImportManager = new ExportImportManager[1];
        logger.debug((Object)"bootstrap");
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

            public void run(KeycloakSession session) {
                JtaTransactionManagerLookup lookup = (JtaTransactionManagerLookup)sessionFactory.getProviderFactory(JtaTransactionManagerLookup.class);
                if (lookup != null && lookup.getTransactionManager() != null) {
                    try {
                        Transaction transaction = lookup.getTransactionManager().getTransaction();
                        logger.debugv("bootstrap current transaction? {0}", (Object)(transaction != null ? 1 : 0));
                        if (transaction != null) {
                            logger.debugv("bootstrap current transaction status? {0}", (Object)transaction.getStatus());
                        }
                    }
                    catch (SystemException e) {
                        throw new RuntimeException(e);
                    }
                }
                ApplianceBootstrap applianceBootstrap = new ApplianceBootstrap(session);
                exportImportManager[0] = new ExportImportManager(session);
                boolean createMasterRealm = applianceBootstrap.isNewInstall();
                if (exportImportManager[0].isRunImport() && exportImportManager[0].isImportMasterIncluded()) {
                    createMasterRealm = false;
                }
                if (createMasterRealm) {
                    applianceBootstrap.createMasterRealm();
                }
            }
        });
        if (exportImportManager[0].isRunImport()) {
            exportImportManager[0].runImport();
        } else {
            this.importRealms();
        }
        this.importAddUser();
        return exportImportManager[0];
    }

    protected void loadConfig() {
        ServiceLoader<ConfigProviderFactory> loader = ServiceLoader.load(ConfigProviderFactory.class, KeycloakApplication.class.getClassLoader());
        try {
            ConfigProviderFactory factory = loader.iterator().next();
            logger.debugv("ConfigProvider: {0}", (Object)factory.getClass().getName());
            Config.init((Config.ConfigProvider)factory.create().orElseThrow(() -> new RuntimeException("Failed to load Keycloak configuration")));
        }
        catch (NoSuchElementException e) {
            throw new RuntimeException("No valid ConfigProvider found");
        }
    }

    public static KeycloakSessionFactory createSessionFactory() {
        DefaultKeycloakSessionFactory factory = new DefaultKeycloakSessionFactory();
        factory.init();
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setupScheduledTasks(KeycloakSessionFactory sessionFactory) {
        long interval = Config.scope((String[])new String[]{"scheduled"}).getLong("interval", Long.valueOf(900L)) * 1000L;
        try (KeycloakSession session = sessionFactory.create();){
            TimerProvider timer = (TimerProvider)session.getProvider(TimerProvider.class);
            timer.schedule((Runnable)new ClusterAwareScheduledTaskRunner(sessionFactory, (ScheduledTask)new ClearExpiredEvents(), interval), interval, "ClearExpiredEvents");
            timer.schedule((Runnable)new ClusterAwareScheduledTaskRunner(sessionFactory, (ScheduledTask)new ClearExpiredClientInitialAccessTokens(), interval), interval, "ClearExpiredClientInitialAccessTokens");
            timer.schedule((Runnable)new ScheduledTaskRunner(sessionFactory, new ClearExpiredUserSessions()), interval, "ClearExpiredUserSessions");
            new UserStorageSyncManager().bootstrapPeriodic(sessionFactory, timer);
        }
    }

    public static KeycloakSessionFactory getSessionFactory() {
        return sessionFactory;
    }

    public Set<Class<?>> getClasses() {
        return this.classes;
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }

    public void importRealms() {
        String files = System.getProperty("keycloak.import");
        if (files != null) {
            StringTokenizer tokenizer = new StringTokenizer(files, ",");
            while (tokenizer.hasMoreTokens()) {
                RealmRepresentation rep;
                String file = tokenizer.nextToken().trim();
                try {
                    rep = KeycloakApplication.loadJson(new FileInputStream(file), RealmRepresentation.class);
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
                this.importRealm(rep, "file " + file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importRealm(RealmRepresentation rep, String from) {
        boolean exists = false;
        try (KeycloakSession session = sessionFactory.create();){
            session.getTransactionManager().begin();
            try {
                RealmManager manager = new RealmManager(session);
                if (rep.getId() != null && manager.getRealm(rep.getId()) != null) {
                    ServicesLogger.LOGGER.realmExists(rep.getRealm(), from);
                    exists = true;
                }
                if (manager.getRealmByName(rep.getRealm()) != null) {
                    ServicesLogger.LOGGER.realmExists(rep.getRealm(), from);
                    exists = true;
                }
                if (!exists) {
                    RealmModel realm = manager.importRealm(rep);
                    ServicesLogger.LOGGER.importedRealm(realm.getName(), from);
                }
                session.getTransactionManager().commit();
            }
            catch (Throwable t) {
                session.getTransactionManager().rollback();
                if (!exists) {
                    ServicesLogger.LOGGER.unableToImportRealm(t, rep.getRealm(), from);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importAddUser() {
        File addUserFile;
        String configDir = System.getProperty("jboss.server.config.dir");
        if (configDir != null && (addUserFile = new File(configDir + File.separator + "keycloak-add-user.json")).isFile()) {
            List realms;
            ServicesLogger.LOGGER.imprtingUsersFrom(addUserFile);
            try {
                realms = (List)JsonSerialization.readValue((InputStream)new FileInputStream(addUserFile), (TypeReference)new TypeReference<List<RealmRepresentation>>(){});
            }
            catch (IOException e) {
                ServicesLogger.LOGGER.failedToLoadUsers(e);
                return;
            }
            for (RealmRepresentation realmRep : realms) {
                for (UserRepresentation userRep : realmRep.getUsers()) {
                    try (KeycloakSession session = sessionFactory.create();){
                        UserProvider users;
                        session.getTransactionManager().begin();
                        RealmModel realm = session.realms().getRealmByName(realmRep.getRealm());
                        if (realm == null) {
                            ServicesLogger.LOGGER.addUserFailedRealmNotFound(userRep.getUsername(), realmRep.getRealm());
                        }
                        if ((users = session.users()).getUserByUsername(realm, userRep.getUsername()) != null) {
                            ServicesLogger.LOGGER.notCreatingExistingUser(userRep.getUsername());
                        } else {
                            UserModel user = users.addUser(realm, userRep.getUsername());
                            user.setEnabled(userRep.isEnabled().booleanValue());
                            RepresentationToModel.createCredentials((UserRepresentation)userRep, (KeycloakSession)session, (RealmModel)realm, (UserModel)user, (boolean)false);
                            RepresentationToModel.createRoleMappings((UserRepresentation)userRep, (UserModel)user, (RealmModel)realm);
                            ServicesLogger.LOGGER.addUserSuccess(userRep.getUsername(), realmRep.getRealm());
                        }
                        session.getTransactionManager().commit();
                    }
                }
            }
            if (!addUserFile.delete()) {
                ServicesLogger.LOGGER.failedToDeleteFile(addUserFile.getAbsolutePath());
            }
        }
    }

    private static <T> T loadJson(InputStream is, Class<T> type) {
        try {
            return (T)JsonSerialization.readValue((InputStream)is, type);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse json", e);
        }
    }
}

