/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.email.freemarker.beans;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.models.UserModel;

public class ProfileBean {
    private static final Logger logger = Logger.getLogger(ProfileBean.class);
    private UserModel user;
    private final Map<String, String> attributes = new HashMap<String, String>();

    public ProfileBean(UserModel user) {
        this.user = user;
        if (user.getAttributes() != null) {
            for (Map.Entry attr : user.getAttributes().entrySet()) {
                List attrValue = (List)attr.getValue();
                if (attrValue != null && attrValue.size() > 0) {
                    this.attributes.put((String)attr.getKey(), (String)attrValue.get(0));
                }
                if (attrValue == null || attrValue.size() <= 1) continue;
                logger.warnf("There are more values for attribute '%s' of user '%s' . Will display just first value", attr.getKey(), (Object)user.getUsername());
            }
        }
    }

    public String getUsername() {
        return this.user.getUsername();
    }

    public String getFirstName() {
        return this.user.getFirstName();
    }

    public String getLastName() {
        return this.user.getLastName();
    }

    public String getEmail() {
        return this.user.getEmail();
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }
}

