/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDockerWorking;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.DevServicesConfigResultBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.deployment.dev.devservices.GlobalDevServicesConfig;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.devservices.common.ContainerLocator;
import io.quarkus.runtime.configuration.ConfigUtils;
import io.quarkus.vault.runtime.config.DevServicesConfig;
import io.quarkus.vault.runtime.config.VaultBuildTimeConfig;
import java.io.Closeable;
import java.time.Duration;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Supplier;
import org.jboss.logging.Logger;
import org.testcontainers.containers.Network;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.vault.VaultContainer;

public class DevServicesVaultProcessor {
    private static final Logger log = Logger.getLogger(DevServicesVaultProcessor.class);
    private static final String VAULT_IMAGE = "vault:1.7.1";
    private static final String DEV_SERVICE_LABEL = "quarkus-dev-service-vault";
    private static final String DEV_SERVICE_TOKEN = "root";
    private static final int VAULT_EXPOSED_PORT = 8200;
    private static final String CONFIG_PREFIX = "quarkus.vault.";
    private static final String URL_CONFIG_KEY = "quarkus.vault.url";
    private static final String AUTH_CONFIG_PREFIX = "quarkus.vault.authentication.";
    private static final String CLIENT_TOKEN_CONFIG_KEY = "quarkus.vault.authentication.client-token";
    private static final ContainerLocator vaultContainerLocator = new ContainerLocator("quarkus-dev-service-vault", 8200);
    private static volatile Closeable closeable;
    private static volatile DevServicesConfig capturedDevServicesConfiguration;
    private static volatile boolean first;
    private final IsDockerWorking isDockerWorking = new IsDockerWorking(true);

    @BuildStep(onlyIfNot={IsNormal.class}, onlyIf={GlobalDevServicesConfig.Enabled.class})
    public void startVaultContainers(BuildProducer<DevServicesConfigResultBuildItem> devConfig, VaultBuildTimeConfig config, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, LaunchModeBuildItem launchMode, CuratedApplicationShutdownBuildItem closeBuildItem, LoggingSetupBuildItem loggingSetupBuildItem, GlobalDevServicesConfig devServicesConfig) {
        DevServicesConfig currentDevServicesConfiguration = config.devservices;
        if (closeable != null) {
            boolean restartRequired;
            boolean bl = restartRequired = !currentDevServicesConfiguration.equals((Object)capturedDevServicesConfiguration);
            if (!restartRequired) {
                return;
            }
            try {
                closeable.close();
            }
            catch (Throwable e) {
                log.error((Object)"Failed to stop Vault container", e);
            }
            closeable = null;
            capturedDevServicesConfiguration = null;
        }
        capturedDevServicesConfiguration = currentDevServicesConfiguration;
        StartupLogCompressor compressor = new StartupLogCompressor((launchMode.isTest() ? "(test) " : "") + "Vault Dev Services Starting:", consoleInstalledBuildItem, loggingSetupBuildItem);
        try {
            VaultInstance vaultInstance = this.startContainer(currentDevServicesConfiguration, launchMode, devServicesConfig.timeout);
            if (vaultInstance != null) {
                closeable = vaultInstance.getCloseable();
                devConfig.produce((BuildItem)new DevServicesConfigResultBuildItem(URL_CONFIG_KEY, vaultInstance.url));
                devConfig.produce((BuildItem)new DevServicesConfigResultBuildItem(CLIENT_TOKEN_CONFIG_KEY, vaultInstance.clientToken));
                if (vaultInstance.isOwner()) {
                    log.info((Object)"Dev Services for Vault started.");
                    log.infof("Other Quarkus applications in dev mode will find the instance automatically. For Quarkus applications in production mode, you can connect to this by starting your application with -D%s=%s -D%s=%s", new Object[]{URL_CONFIG_KEY, vaultInstance.url, CLIENT_TOKEN_CONFIG_KEY, vaultInstance.clientToken});
                }
            }
            compressor.close();
        }
        catch (Throwable t) {
            compressor.closeAndDumpCaptured();
            throw new RuntimeException(t);
        }
        if (first) {
            first = false;
            Runnable closeTask = new Runnable(){

                @Override
                public void run() {
                    if (closeable != null) {
                        try {
                            closeable.close();
                        }
                        catch (Throwable t) {
                            log.error((Object)"Failed to stop Vault container", t);
                        }
                        closeable = null;
                        log.info((Object)"Dev Services for Vault shut down.");
                    }
                    first = true;
                    capturedDevServicesConfiguration = null;
                }
            };
            closeBuildItem.addCloseTask(closeTask, true);
        }
    }

    private VaultInstance startContainer(DevServicesConfig devServicesConfig, LaunchModeBuildItem launchMode, Optional<Duration> timeout) {
        boolean needToStart;
        if (!devServicesConfig.enabled) {
            log.debug((Object)"Not starting devservices for Vault as it has been disabled in the config");
            return null;
        }
        boolean bl = needToStart = !ConfigUtils.isPropertyPresent((String)URL_CONFIG_KEY);
        if (!needToStart) {
            log.debug((Object)"Not starting devservices for default Vault client as url has been provided");
            return null;
        }
        if (!this.isDockerWorking.getAsBoolean()) {
            log.warn((Object)"Please configure Vault URL or get a working docker instance");
            return null;
        }
        DockerImageName dockerImageName = DockerImageName.parse((String)devServicesConfig.imageName.orElse(VAULT_IMAGE)).asCompatibleSubstituteFor(VAULT_IMAGE);
        ConfiguredVaultContainer vaultContainer = (ConfiguredVaultContainer)new ConfiguredVaultContainer(dockerImageName, devServicesConfig.port, devServicesConfig.serviceName).withVaultToken(DEV_SERVICE_TOKEN);
        vaultContainer.withNetwork(Network.SHARED);
        if (devServicesConfig.transitEnabled) {
            vaultContainer.withInitCommand(new String[]{"secrets enable transit"});
        }
        if (devServicesConfig.pkiEnabled) {
            vaultContainer.withInitCommand(new String[]{"secrets enable pki"});
        }
        devServicesConfig.initCommands.ifPresent(initCommands -> initCommands.forEach(xva$0 -> {
            ConfiguredVaultContainer cfr_ignored_0 = (ConfiguredVaultContainer)vaultContainer.withInitCommand(new String[]{xva$0});
        }));
        Supplier<VaultInstance> defaultVaultInstanceSupplier = () -> {
            timeout.ifPresent(arg_0 -> ((ConfiguredVaultContainer)vaultContainer).withStartupTimeout(arg_0));
            vaultContainer.start();
            return new VaultInstance(vaultContainer.getHost(), vaultContainer.getPort(), DEV_SERVICE_TOKEN, () -> ((ConfiguredVaultContainer)vaultContainer).close());
        };
        return vaultContainerLocator.locateContainer(devServicesConfig.serviceName, devServicesConfig.shared, launchMode.getLaunchMode()).map(containerAddress -> new VaultInstance(containerAddress.getHost(), containerAddress.getPort(), DEV_SERVICE_TOKEN, null)).orElseGet(defaultVaultInstanceSupplier);
    }

    static {
        first = true;
    }

    private static class ConfiguredVaultContainer
    extends VaultContainer<ConfiguredVaultContainer> {
        OptionalInt fixedExposedPort;

        public ConfiguredVaultContainer(DockerImageName dockerImageName, OptionalInt fixedExposedPort, String serviceName) {
            super(dockerImageName);
            this.fixedExposedPort = fixedExposedPort;
            this.withNetwork(Network.SHARED);
            if (serviceName != null) {
                this.withLabel(DevServicesVaultProcessor.DEV_SERVICE_LABEL, serviceName);
            }
        }

        protected void configure() {
            super.configure();
            if (this.fixedExposedPort.isPresent()) {
                this.addFixedExposedPort(this.fixedExposedPort.getAsInt(), 8200);
            } else {
                this.addExposedPort(8200);
            }
        }

        public int getPort() {
            if (this.fixedExposedPort.isPresent()) {
                return this.fixedExposedPort.getAsInt();
            }
            return super.getMappedPort(8200);
        }
    }

    private static class VaultInstance {
        private final String url;
        private final String clientToken;
        private final Closeable closeable;

        public VaultInstance(String host, int port, String clientToken, Closeable closeable) {
            this("http://" + host + ":" + port, clientToken, closeable);
        }

        public VaultInstance(String url, String clientToken, Closeable closeable) {
            this.url = url;
            this.clientToken = clientToken;
            this.closeable = closeable;
        }

        public boolean isOwner() {
            return this.closeable != null;
        }

        public Closeable getCloseable() {
            return this.closeable;
        }
    }
}

