/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core;

import io.opentracing.Span;
import io.opentracing.Tracer;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;

public class RequestTracer {
    private static final Log log = LogFactory.getLog(RequestTracer.class);
    private static TracerAdapter adapter;
    public static final String TRACER_FACTORY_CLASS;
    public static final String TRACER_FACTORY_METHOD;

    public static void start() {
    }

    public static void stop() {
        if (adapter != null) {
            adapter.stop();
        }
    }

    public static Object requestStart(String operationName) {
        if (adapter != null) {
            return adapter.requestStart(operationName);
        }
        return null;
    }

    public static void requestEnd(Object span) {
        if (adapter != null) {
            adapter.requestEnd(span);
        }
    }

    static {
        TRACER_FACTORY_CLASS = System.getProperty("infinispan.opentracing.factory.class");
        TRACER_FACTORY_METHOD = System.getProperty("infinispan.opentracing.factory.method");
        if (TRACER_FACTORY_CLASS != null && TRACER_FACTORY_METHOD != null) {
            try {
                Class<?> tracerFactoryClass = Thread.currentThread().getContextClassLoader().loadClass(TRACER_FACTORY_CLASS);
                Method getTracer = tracerFactoryClass.getMethod(TRACER_FACTORY_METHOD, new Class[0]);
                Object factoryInstance = Modifier.isStatic(getTracer.getModifiers()) ? null : tracerFactoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                adapter = new TracerAdapter((Tracer)getTracer.invoke(factoryInstance, new Object[0]));
                log.infof("OpenTracing implementation loaded: %s", (Object)adapter);
            }
            catch (Throwable e) {
                log.warnf(e, "OpenTracing implementation could not be loaded", new Object[0]);
            }
        } else {
            log.info((Object)"OpenTracing integration is disabled");
        }
    }

    public static class TracerAdapter {
        private Tracer tracer;

        public TracerAdapter(Tracer tracer) {
            this.tracer = tracer;
        }

        public void stop() {
            if (this.tracer instanceof AutoCloseable) {
                try {
                    ((AutoCloseable)this.tracer).close();
                }
                catch (Exception e) {
                    log.warn((Object)"OpenTracing error during stop", (Throwable)e);
                }
            }
        }

        public Object requestStart(String operationName) {
            return this.tracer.buildSpan(operationName).start();
        }

        public void requestEnd(Object span) {
            if (span instanceof Span) {
                ((Span)span).finish();
            }
        }

        public String toString() {
            return this.tracer.toString();
        }
    }
}

