/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.transport;

import io.netty.channel.group.ChannelGroup;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.SerializeWith;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.transport.SecurityActions;

class NettyTransportConnectionStats {
    private final EmbeddedCacheManager cacheManager;
    private final boolean isGlobalStatsEnabled;
    private final ChannelGroup acceptedChannels;
    private final String threadNamePrefix;
    private final AtomicLong totalBytesWritten = new AtomicLong();
    private final AtomicLong totalBytesRead = new AtomicLong();

    public NettyTransportConnectionStats(EmbeddedCacheManager cacheManager, ChannelGroup acceptedChannels, String threadNamePrefix) {
        this.cacheManager = cacheManager;
        this.acceptedChannels = acceptedChannels;
        this.threadNamePrefix = threadNamePrefix;
        this.isGlobalStatsEnabled = cacheManager != null && SecurityActions.getCacheManagerConfiguration(cacheManager).statistics();
    }

    private void increment(AtomicLong base, long bytes) {
        if (this.isGlobalStatsEnabled) {
            base.addAndGet(bytes);
        }
    }

    public void incrementTotalBytesWritten(long bytes) {
        this.increment(this.totalBytesWritten, bytes);
    }

    public void incrementTotalBytesRead(long bytes) {
        this.increment(this.totalBytesRead, bytes);
    }

    public long getTotalBytesWritten() {
        return this.totalBytesWritten.get();
    }

    public long getTotalBytesRead() {
        return this.totalBytesRead.get();
    }

    private boolean needDistributedCalculation() {
        if (this.cacheManager != null) {
            return this.cacheManager.getMembers() != null && this.cacheManager.getMembers().size() > 1;
        }
        return false;
    }

    private int calculateGlobalConnections() {
        AtomicInteger connectionCount = new AtomicInteger();
        CompletableFuture results = SecurityActions.getClusterExecutor(this.cacheManager).submitConsumer((Function)new ConnectionAdderTask(this.threadNamePrefix), (a, v, t) -> {
            if (t != null) {
                throw new CacheException(t);
            }
            connectionCount.addAndGet((int)v);
        });
        try {
            results.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new CacheException((Throwable)e);
        }
        return connectionCount.get();
    }

    public Integer getNumberOfLocalConnections() {
        return this.acceptedChannels.size();
    }

    public Integer getNumberOfGlobalConnections() {
        if (this.needDistributedCalculation()) {
            return this.calculateGlobalConnections();
        }
        return this.getNumberOfLocalConnections();
    }

    @SerializeWith(value=Externalizer.class)
    static class ConnectionAdderTask
    implements Function<EmbeddedCacheManager, Integer> {
        private final String serverName;

        ConnectionAdderTask(String serverName) {
            this.serverName = serverName;
        }

        @Override
        public Integer apply(EmbeddedCacheManager embeddedCacheManager) {
            return ((ProtocolServer)SecurityActions.getGlobalComponentRegistry(embeddedCacheManager).getComponent(ProtocolServer.class, this.serverName)).getTransport().getNumberOfLocalConnections();
        }

        public static class Externalizer
        implements org.infinispan.commons.marshall.Externalizer<ConnectionAdderTask> {
            public void writeObject(ObjectOutput output, ConnectionAdderTask task) throws IOException {
                output.writeUTF(task.serverName);
            }

            public ConnectionAdderTask readObject(ObjectInput input) throws IOException, ClassNotFoundException {
                return new ConnectionAdderTask(input.readUTF());
            }
        }
    }
}

