/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.irac;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.container.versioning.irac.IracTombstoneInfo;
import org.infinispan.container.versioning.irac.IracTombstoneManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CompletableFutures;

public class IracTombstoneStateResponseCommand
implements CacheRpcCommand {
    public static final byte COMMAND_ID = 39;
    private ByteString cacheName;
    private Collection<IracTombstoneInfo> state;

    public IracTombstoneStateResponseCommand() {
    }

    public IracTombstoneStateResponseCommand(ByteString cacheName) {
        this.cacheName = cacheName;
    }

    public IracTombstoneStateResponseCommand(ByteString cacheName, Collection<IracTombstoneInfo> state) {
        this.cacheName = cacheName;
        this.state = state;
    }

    public CompletionStage<Void> invokeAsync(ComponentRegistry registry) {
        IracTombstoneManager tombstoneManager = registry.getIracTombstoneManager().running();
        for (IracTombstoneInfo data : this.state) {
            tombstoneManager.storeTombstoneIfAbsent(data);
        }
        return CompletableFutures.completedNull();
    }

    @Override
    public byte getCommandId() {
        return 39;
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        MarshallUtil.marshallCollection(this.state, (ObjectOutput)output, IracTombstoneInfo::writeTo);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.state = MarshallUtil.unmarshallCollection((ObjectInput)input, ArrayList::new, IracTombstoneInfo::readFrom);
    }

    @Override
    public ByteString getCacheName() {
        return this.cacheName;
    }

    @Override
    public Address getOrigin() {
        return null;
    }

    @Override
    public void setOrigin(Address origin) {
    }

    public String toString() {
        return "IracTombstoneStateResponseCommand{cacheName=" + this.cacheName + ", state=" + this.state + '}';
    }
}

