/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.jose.jwk;

import java.security.Key;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Collections;
import java.util.List;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.KeyUtils;
import org.keycloak.common.util.PemUtils;
import org.keycloak.crypto.KeyUse;
import org.keycloak.jose.jwk.ECPublicJWK;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.jose.jwk.JWKUtil;
import org.keycloak.jose.jwk.RSAPublicJWK;

public class JWKBuilder {
    public static final String DEFAULT_PUBLIC_KEY_USE = "sig";
    private String kid;
    private String algorithm;

    private JWKBuilder() {
    }

    public static JWKBuilder create() {
        return new JWKBuilder();
    }

    public JWKBuilder kid(String kid) {
        this.kid = kid;
        return this;
    }

    public JWKBuilder algorithm(String algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public JWK rs256(PublicKey key) {
        this.algorithm("RS256");
        return this.rsa(key);
    }

    public JWK rsa(Key key) {
        return this.rsa(key, null, KeyUse.SIG);
    }

    public JWK rsa(Key key, X509Certificate certificate) {
        return this.rsa(key, Collections.singletonList(certificate), KeyUse.SIG);
    }

    public JWK rsa(Key key, List<X509Certificate> certificates) {
        return this.rsa(key, certificates, null);
    }

    public JWK rsa(Key key, List<X509Certificate> certificates, KeyUse keyUse) {
        RSAPublicKey rsaKey = (RSAPublicKey)key;
        RSAPublicJWK k = new RSAPublicJWK();
        String kid = this.kid != null ? this.kid : KeyUtils.createKeyId((Key)key);
        k.setKeyId(kid);
        k.setKeyType("RSA");
        k.setAlgorithm(this.algorithm);
        k.setPublicKeyUse(keyUse == null ? KeyUse.SIG.getSpecName() : keyUse.getSpecName());
        k.setModulus(Base64Url.encode((byte[])JWKUtil.toIntegerBytes(rsaKey.getModulus())));
        k.setPublicExponent(Base64Url.encode((byte[])JWKUtil.toIntegerBytes(rsaKey.getPublicExponent())));
        if (certificates != null && !certificates.isEmpty()) {
            String[] certificateChain = new String[certificates.size()];
            for (int i = 0; i < certificates.size(); ++i) {
                certificateChain[i] = PemUtils.encodeCertificate((Certificate)certificates.get(i));
            }
            k.setX509CertificateChain(certificateChain);
        }
        return k;
    }

    public JWK rsa(Key key, KeyUse keyUse) {
        String keyUseString;
        JWK k = this.rsa(key);
        String string = keyUseString = keyUse == null ? DEFAULT_PUBLIC_KEY_USE : keyUse.getSpecName();
        if (KeyUse.ENC == keyUse) {
            keyUseString = "enc";
        }
        k.setPublicKeyUse(keyUseString);
        return k;
    }

    public JWK ec(Key key) {
        ECPublicKey ecKey = (ECPublicKey)key;
        ECPublicJWK k = new ECPublicJWK();
        String kid = this.kid != null ? this.kid : KeyUtils.createKeyId((Key)key);
        int fieldSize = ecKey.getParams().getCurve().getField().getFieldSize();
        k.setKeyId(kid);
        k.setKeyType("EC");
        k.setAlgorithm(this.algorithm);
        k.setPublicKeyUse(DEFAULT_PUBLIC_KEY_USE);
        k.setCrv("P-" + fieldSize);
        k.setX(Base64Url.encode((byte[])JWKUtil.toIntegerBytes(ecKey.getW().getAffineX())));
        k.setY(Base64Url.encode((byte[])JWKUtil.toIntegerBytes(ecKey.getW().getAffineY())));
        return k;
    }
}

