/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.checks;

import com.datical.liquibase.ext.checks.config.CheckSettingsConfigHelper;
import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.CheckSettingsConfig;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRuleParameter;
import com.datical.liquibase.ext.command.checks.AbstractChecksCommandStep;
import com.datical.liquibase.ext.command.checks.ChecksShowCommandStep;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import liquibase.Scope;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.exception.CommandExecutionException;

public class ChecksResetCommandStep
extends AbstractChecksCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"checks", "reset"};
    public static final CommandArgumentDefinition<String> CHECK_NAME_ARG;
    public static final CommandArgumentDefinition<String> CHECKS_SETTINGS_FILE_ARG;
    public static final CommandArgumentDefinition<String> CHECKS_AUTO_UPDATE_ARG;

    @Override
    public final void run(CommandResultsBuilder commandResultsBuilder) {
        Object object2;
        Object object3 = commandResultsBuilder.getCommandScope();
        String string = ((CommandScope)object3).getConfiguredValue(CHECKS_SETTINGS_FILE_ARG).getValue();
        ChecksResetCommandStep.checkFileArgExistence(string, "checks settings", false);
        String string2 = ((CommandScope)object3).getConfiguredValue(CHECK_NAME_ARG).getValue();
        Object object4 = ChecksResetCommandStep.listAllRules();
        object3 = ((CommandScope)object3).getConfiguredValue(CHECKS_AUTO_UPDATE_ARG).getValue();
        object3 = new CheckSettingsConfigHelper(string, (String)object3);
        CheckSettingsConfig checkSettingsConfig = ((CheckSettingsConfigHelper)object3).read((List<AbstractLiquibaseRule>)object4);
        if (checkSettingsConfig == null) {
            commandResultsBuilder.addResult("statusCode", (Object)0);
            return;
        }
        Object object5 = object4.stream().filter(abstractLiquibaseRule -> abstractLiquibaseRule.getShortName().equalsIgnoreCase(string2)).findFirst();
        if (((Optional)object5).isPresent() && !((Optional)object5).get().isConfigurable()) {
            if (this.resetBasicRule(string2, (CheckSettingsConfigHelper)object3, checkSettingsConfig, (AbstractLiquibaseRule)((Optional)object5).get())) {
                ChecksShowCommandStep.writeTableToOutput(commandResultsBuilder, string, false);
            }
            commandResultsBuilder.addResult("statusCode", (Object)0);
            return;
        }
        object5 = checkSettingsConfig.getDynamicConfigurableRuleByShortName(string2, "has not been customized and is not a copy. It cannot be reset");
        object4 = ChecksResetCommandStep.findConfigurableParentRule((AbstractConfigurableRule)object5, object4, string2, "does not have customization options");
        if (!((AbstractLiquibaseRule)object4).hasDefaultParameterValues() && !((DynamicRule)object5).isCopy()) {
            throw new CommandExecutionException("This check can not be reset because it is not a copy of a check or has no customization options.");
        }
        if (!((AbstractLiquibaseRule)object4).hasDefaultParameterValues() && ((DynamicRule)object5).isCopy()) {
            throw new CommandExecutionException("This check can not be reset because the check from which it was copied does not include default values for one or more fields.  If you no longer need to run this check delete it or disable it.");
        }
        Scope.getCurrentScope().getUI().sendMessage(System.lineSeparator() + "Resetting check with short name '" + ((DynamicRule)object5).getShortName() + "' to original configuration of its base check '" + ((AbstractLiquibaseRule)object4).getShortName() + "'");
        object4 = ((AbstractLiquibaseRule)object4).getParameters();
        ArrayList<DynamicRuleParameter> arrayList = new ArrayList<DynamicRuleParameter>(object4.size());
        Object object6 = object4.iterator();
        while (object6.hasNext()) {
            object2 = object6.next();
            arrayList.add(new DynamicRuleParameter(((RuleParameter)object2).getParameter(), ((RuleParameter)object2).getDefaultValue()));
        }
        object6 = new StringBuilder(System.lineSeparator() + "Current Customization Settings" + System.lineSeparator());
        ((StringBuilder)object6).append("Severity = ").append((Object)((AbstractConfigurableRule)object5).getSeverity());
        for (DynamicRuleParameter object7 : ((DynamicRule)object5).getParameters()) {
            ((StringBuilder)object6).append("  ");
            ((StringBuilder)object6).append(object7.getParameterAsEnum().toString());
            ((StringBuilder)object6).append(" = '");
            ((StringBuilder)object6).append(object7.getValue());
            ((StringBuilder)object6).append("'");
            ((StringBuilder)object6).append(System.lineSeparator());
        }
        Scope.getCurrentScope().getUI().sendMessage(((StringBuilder)object6).toString());
        object2 = new StringBuilder("Default Settings" + System.lineSeparator());
        ((StringBuilder)object2).append("Severity = ").append((Object)SeverityEnum.INFO);
        Iterator<RuleParameter<?>> iterator = object4.iterator();
        while (iterator.hasNext()) {
            object4 = iterator.next();
            ((StringBuilder)object2).append("  ");
            ((StringBuilder)object2).append(((RuleParameter)object4).toString());
            ((StringBuilder)object2).append(" = '");
            ((StringBuilder)object2).append(((RuleParameter)object4).getDefaultValue());
            ((StringBuilder)object2).append("'");
            ((StringBuilder)object2).append(System.lineSeparator());
        }
        Scope.getCurrentScope().getUI().sendMessage(((StringBuilder)object2).toString());
        String string3 = this.getShouldReset(string2);
        if (string3 != null && string3.equalsIgnoreCase("y")) {
            ((AbstractConfigurableRule)object5).setSeverity(SeverityEnum.INFO);
            ((DynamicRule)object5).getParameters().clear();
            ((DynamicRule)object5).getParameters().addAll(arrayList);
            ((CheckSettingsConfigHelper)object3).write(checkSettingsConfig);
            Scope.getCurrentScope().getUI().sendMessage("Reset complete. Review the table below to confirm your changes.");
        } else {
            Scope.getCurrentScope().getUI().sendMessage("No changes have been made to check configuration.");
        }
        ChecksShowCommandStep.writeTableToOutput(commandResultsBuilder, string, false);
        Scope.getCurrentScope().getUI().sendMessage(System.lineSeparator() + "TIP" + System.lineSeparator() + "  Test your changes by running checks against your changelog with 'liquibase checks run'" + System.lineSeparator());
        commandResultsBuilder.addResult("statusCode", (Object)0);
    }

    private boolean resetBasicRule(String string, CheckSettingsConfigHelper checkSettingsConfigHelper, CheckSettingsConfig checkSettingsConfig, AbstractLiquibaseRule abstractLiquibaseRule) {
        Scope.getCurrentScope().getUI().sendMessage(System.lineSeparator() + "Resetting check with short name '" + abstractLiquibaseRule.getShortName() + "' to original configuration of its base check '");
        AbstractConfigurableRule abstractConfigurableRule = checkSettingsConfig.getRuleById(abstractLiquibaseRule.getId());
        if (abstractConfigurableRule == null) {
            throw new CommandExecutionException("Unable to locate check to modify '" + abstractLiquibaseRule.getShortName() + "' in configuration settings.");
        }
        Scope.getCurrentScope().getUI().sendMessage(System.lineSeparator() + "Current Customization Settings" + System.lineSeparator());
        Scope.getCurrentScope().getUI().sendMessage("Severity = " + (Object)((Object)abstractConfigurableRule.getSeverity()));
        Scope.getCurrentScope().getUI().sendMessage("Default severity = " + (Object)((Object)SeverityEnum.INFO));
        string = this.getShouldReset(string);
        if (string == null || !string.equalsIgnoreCase("y")) {
            Scope.getCurrentScope().getUI().sendMessage("No changes have been made to check configuration.");
            return false;
        }
        abstractConfigurableRule.setSeverity(SeverityEnum.INFO);
        checkSettingsConfigHelper.write(checkSettingsConfig);
        Scope.getCurrentScope().getUI().sendMessage("Reset complete. Review the table below to confirm your changes.");
        return true;
    }

    private String getShouldReset(String string2) {
        return Scope.getCurrentScope().getUI().prompt("Would you like to set '" + string2 + "' to it's default settings? (Y/n)", "Y", (string, clazz) -> {
            if (string == null || !string.equalsIgnoreCase("y") && !string.equalsIgnoreCase("n")) {
                throw new IllegalArgumentException();
            }
            return string;
        }, String.class);
    }

    @Override
    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    @Override
    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setShortDescription("Reset the customization options for a check to defaults");
        commandDefinition.setGroupShortDescription(new String[]{"checks"}, "Quality Checks commands");
    }

    static {
        CommandBuilder commandBuilder = new CommandBuilder(new String[][]{COMMAND_NAME});
        CHECK_NAME_ARG = commandBuilder.argument("checkName", String.class).required().description("Name of check to reset").build();
        CHECKS_SETTINGS_FILE_ARG = commandBuilder.argument("checksSettingsFile", String.class).description("Relative or fully qualified path to a configuration file for checks execution").build();
        CHECKS_AUTO_UPDATE_ARG = commandBuilder.argument("autoUpdate", String.class).description("Allows automatic backup and updating of liquibase.checks.conf file when new quality checks are available. Options: [on|off]").setValueHandler(object -> {
            if (object == null) {
                return null;
            }
            if (((String)(object = (String)object)).equalsIgnoreCase("on") || ((String)object).equalsIgnoreCase("off")) {
                return object;
            }
            object = "\nWARNING:  The autoUpdate value '" + (String)object + "' is not valid.  Valid values include: 'on' or 'off'";
            throw new IllegalArgumentException((String)object);
        }).build();
    }
}

