/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.statement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.webauthn4j.data.attestation.statement.AttestationCertificatePath;
import com.webauthn4j.data.attestation.statement.CertificateBaseAttestationStatement;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.validator.exception.ConstraintViolationException;
import java.util.Arrays;
import java.util.Objects;

@JsonIgnoreProperties(value={"format"})
@JsonTypeName(value="fido-u2f")
public class FIDOU2FAttestationStatement
implements CertificateBaseAttestationStatement {
    public static final String FORMAT = "fido-u2f";
    @JsonProperty
    private final AttestationCertificatePath x5c;
    @JsonProperty
    private final byte[] sig;

    @JsonCreator
    public FIDOU2FAttestationStatement(@JsonProperty(value="x5c") AttestationCertificatePath x5c, @JsonProperty(value="sig") byte[] sig) {
        this.x5c = x5c;
        this.sig = sig;
    }

    @Override
    public AttestationCertificatePath getX5c() {
        return this.x5c;
    }

    public byte[] getSig() {
        return ArrayUtil.clone((byte[])this.sig);
    }

    @Override
    public String getFormat() {
        return FORMAT;
    }

    @Override
    public void validate() {
        if (this.x5c == null) {
            throw new ConstraintViolationException("x5c must not be null");
        }
        if (this.x5c.size() != 1) {
            throw new ConstraintViolationException("x5c must have exactly one certificate");
        }
        if (this.sig == null) {
            throw new ConstraintViolationException("sig must not be null");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FIDOU2FAttestationStatement that = (FIDOU2FAttestationStatement)o;
        return Objects.equals(this.x5c, that.x5c) && Arrays.equals(this.sig, that.sig);
    }

    public int hashCode() {
        int result = Objects.hash(this.x5c);
        result = 31 * result + Arrays.hashCode(this.sig);
        return result;
    }
}

