/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.core.parameters.converters;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.resteasy.reactive.server.core.parameters.converters.DelegatingParameterConverterSupplier;
import org.jboss.resteasy.reactive.server.core.parameters.converters.ParameterConverter;
import org.jboss.resteasy.reactive.server.core.parameters.converters.ParameterConverterSupplier;
import org.jboss.resteasy.reactive.server.model.ParamConverterProviders;

public class ListConverter
implements ParameterConverter {
    private final ParameterConverter delegate;

    public ListConverter(ParameterConverter delegate) {
        this.delegate = delegate;
    }

    @Override
    public Object convert(Object parameter) {
        if (parameter instanceof List) {
            if (this.delegate == null) {
                return parameter;
            }
            ArrayList<Object> ret = new ArrayList<Object>();
            List values = (List)parameter;
            for (String val : values) {
                ret.add(this.delegate.convert(val));
            }
            return ret;
        }
        if (parameter == null) {
            return Collections.emptyList();
        }
        if (this.delegate != null) {
            return Collections.singletonList(this.delegate.convert(parameter));
        }
        return Collections.singletonList(parameter);
    }

    @Override
    public void init(ParamConverterProviders deployment, Class<?> rawType, Type genericType, Annotation[] annotations) {
        if (this.delegate != null) {
            this.delegate.init(deployment, rawType, genericType, annotations);
        }
    }

    public ParameterConverter getDelegate() {
        return this.delegate;
    }

    public static class ListSupplier
    implements DelegatingParameterConverterSupplier {
        private ParameterConverterSupplier delegate;

        public ListSupplier() {
        }

        public ListSupplier(ParameterConverterSupplier delegate) {
            this.delegate = delegate;
        }

        @Override
        public ParameterConverter get() {
            return this.delegate == null ? new ListConverter(null) : new ListConverter((ParameterConverter)this.delegate.get());
        }

        @Override
        public String getClassName() {
            return ListConverter.class.getName();
        }

        @Override
        public ParameterConverterSupplier getDelegate() {
            return this.delegate;
        }

        public ListSupplier setDelegate(ParameterConverterSupplier delegate) {
            this.delegate = delegate;
            return this;
        }
    }
}

