/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.configuration.io;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.infinispan.commons.configuration.io.ConfigurationFormatFeature;
import org.infinispan.commons.configuration.io.json.JsonConfigurationWriter;
import org.infinispan.commons.configuration.io.xml.XmlConfigurationWriter;
import org.infinispan.commons.configuration.io.yaml.YamlConfigurationWriter;
import org.infinispan.commons.dataconversion.MediaType;

public interface ConfigurationWriter
extends AutoCloseable {
    public static Builder to(OutputStream os) {
        return new Builder(os);
    }

    public static Builder to(Writer writer) {
        return new Builder(writer);
    }

    public boolean clearTextSecrets();

    public void writeStartDocument();

    public void writeStartElement(String var1);

    public void writeStartElement(Enum<?> var1);

    public void writeStartElement(String var1, String var2, String var3);

    public void writeStartElement(String var1, String var2, Enum<?> var3);

    public void writeStartArrayElement(String var1);

    public void writeStartArrayElement(Enum<?> var1);

    public void writeEndArrayElement();

    public void writeArrayElement(String var1, String var2, String var3, Iterable<String> var4);

    public void writeArrayElement(Enum<?> var1, Enum<?> var2, Enum<?> var3, Iterable<String> var4);

    public void writeStartListElement(String var1, boolean var2);

    public void writeStartListElement(Enum<?> var1, boolean var2);

    public void writeStartListElement(String var1, String var2, String var3, boolean var4);

    public void writeStartListElement(String var1, String var2, Enum<?> var3, boolean var4);

    public void writeEndListElement();

    public void writeStartMap(String var1);

    public void writeStartMap(Enum<?> var1);

    public void writeMapItem(String var1, String var2, String var3, String var4);

    public void writeMapItem(Enum<?> var1, Enum<?> var2, String var3, String var4);

    public void writeMapItem(String var1, String var2, String var3);

    public void writeMapItem(Enum<?> var1, Enum<?> var2, String var3);

    public void writeEndMapItem();

    public void writeEndMap();

    public void writeDefaultNamespace(String var1);

    public void writeEndElement();

    public void writeEndDocument();

    public void writeAttribute(Enum<?> var1, String var2);

    public void writeAttribute(String var1, String var2);

    public void writeAttribute(Enum<?> var1, boolean var2);

    public void writeAttribute(String var1, boolean var2);

    public void writeAttribute(Enum<?> var1, Iterable<String> var2);

    public void writeAttribute(String var1, Iterable<String> var2);

    public void writeCharacters(String var1);

    public void writeEmptyElement(String var1);

    public void writeEmptyElement(Enum<?> var1);

    public void writeComment(String var1);

    public void writeNamespace(String var1, String var2);

    public boolean hasFeature(ConfigurationFormatFeature var1);

    @Override
    public void close();

    public static class Builder {
        private final BufferedWriter writer;
        private MediaType type = MediaType.APPLICATION_XML;
        private boolean prettyPrint = true;
        private boolean clearTextSecrets = false;

        private Builder(OutputStream os) {
            this(new OutputStreamWriter(os));
        }

        private Builder(Writer writer) {
            this.writer = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
        }

        public Builder withType(MediaType type) {
            this.type = type;
            return this;
        }

        public Builder prettyPrint(boolean prettyPrint) {
            this.prettyPrint = prettyPrint;
            return this;
        }

        public Builder clearTextSecrets(boolean clearTextSecrets) {
            this.clearTextSecrets = clearTextSecrets;
            return this;
        }

        public ConfigurationWriter build() {
            switch (this.type.toString()) {
                case "application/xml": {
                    return new XmlConfigurationWriter(this.writer, this.prettyPrint, this.clearTextSecrets);
                }
                case "application/yaml": {
                    return new YamlConfigurationWriter(this.writer, this.clearTextSecrets);
                }
                case "application/json": {
                    return new JsonConfigurationWriter(this.writer, this.prettyPrint, this.clearTextSecrets);
                }
            }
            throw new IllegalArgumentException(this.type.toString());
        }
    }
}

