/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.ConfigMessages;
import io.smallrye.config.SecuritySupport;
import io.smallrye.config.common.utils.StringUtil;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.microprofile.config.spi.Converter;

class ImplicitConverters {
    private ImplicitConverters() {
    }

    static <T> Converter<T> getConverter(Class<? extends T> clazz) {
        if (clazz.isEnum()) {
            return new HyphenateEnumConverter<T>(clazz);
        }
        Converter<? extends T> converter = ImplicitConverters.getConverterFromStaticMethod(clazz, "of", String.class);
        if (converter == null && (converter = ImplicitConverters.getConverterFromStaticMethod(clazz, "of", CharSequence.class)) == null && (converter = ImplicitConverters.getConverterFromStaticMethod(clazz, "valueOf", String.class)) == null && (converter = ImplicitConverters.getConverterFromStaticMethod(clazz, "valueOf", CharSequence.class)) == null && (converter = ImplicitConverters.getConverterFromStaticMethod(clazz, "parse", String.class)) == null && (converter = ImplicitConverters.getConverterFromStaticMethod(clazz, "parse", CharSequence.class)) == null && (converter = ImplicitConverters.getConverterFromConstructor(clazz, String.class)) == null) {
            converter = ImplicitConverters.getConverterFromConstructor(clazz, CharSequence.class);
        }
        return converter;
    }

    private static <T> Converter<T> getConverterFromConstructor(Class<? extends T> clazz, Class<? super String> paramType) {
        try {
            Constructor<? extends T> declaredConstructor = SecuritySupport.getDeclaredConstructor(clazz, paramType);
            if (!ImplicitConverters.isAccessible(declaredConstructor)) {
                SecuritySupport.setAccessible(declaredConstructor, true);
            }
            return new ConstructorConverter<T>(declaredConstructor);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static <T> Converter<T> getConverterFromStaticMethod(Class<? extends T> clazz, String methodName, Class<? super String> paramType) {
        try {
            Method method = clazz.getMethod(methodName, paramType);
            if (clazz != method.getReturnType()) {
                return null;
            }
            if (!Modifier.isStatic(method.getModifiers())) {
                return null;
            }
            if (!ImplicitConverters.isAccessible(method)) {
                SecuritySupport.setAccessible(method, true);
            }
            return new StaticMethodConverter<T>(clazz, method);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static boolean isAccessible(Executable e) {
        return Modifier.isPublic(e.getModifiers()) && Modifier.isPublic(e.getDeclaringClass().getModifiers()) || e.isAccessible();
    }

    static class HyphenateEnumConverter<E extends Enum<E>>
    implements Converter<E>,
    Serializable {
        private static final long serialVersionUID = -8298320652413719873L;
        private final Class<E> enumType;
        private final Map<String, E> values = new HashMap<String, E>();

        public HyphenateEnumConverter(Class<E> enumType) {
            this.enumType = enumType;
            for (Enum enumValue : (Enum[])this.enumType.getEnumConstants()) {
                this.values.put(StringUtil.hyphenate((String)enumValue.name()), enumValue);
            }
        }

        public E convert(String value) throws IllegalArgumentException, NullPointerException {
            String trimmedValue = value.trim();
            if (trimmedValue.isEmpty()) {
                return null;
            }
            String hyphenatedValue = StringUtil.hyphenate((String)trimmedValue);
            Enum enumValue = (Enum)this.values.get(hyphenatedValue);
            if (enumValue != null) {
                return (E)((Enum)this.enumType.cast(enumValue));
            }
            throw new IllegalArgumentException(String.format("Cannot convert %s to enum %s", value, this.enumType));
        }
    }

    static class ConstructorConverter<T>
    implements Converter<T>,
    Serializable {
        private static final long serialVersionUID = 3350265927359848883L;
        private final Constructor<? extends T> ctor;

        public ConstructorConverter(Constructor<? extends T> ctor) {
            this.ctor = ctor;
        }

        public T convert(String value) {
            if (value.isEmpty()) {
                return null;
            }
            try {
                return this.ctor.newInstance(value);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw ConfigMessages.msg.constructorConverterFailure(e);
            }
        }

        Object writeReplace() {
            return new Serialized(this.ctor.getDeclaringClass(), this.ctor.getParameterTypes()[0]);
        }

        static final class Serialized
        implements Serializable {
            private static final long serialVersionUID = -2903564775826815453L;
            private final Class<?> c;
            private final Class<?> p;

            Serialized(Class<?> c, Class<?> p) {
                this.c = c;
                this.p = p;
            }

            Object readResolve() throws ObjectStreamException {
                return ImplicitConverters.getConverter(this.c);
            }
        }
    }

    static class StaticMethodConverter<T>
    implements Converter<T>,
    Serializable {
        private static final long serialVersionUID = 3350265927359848883L;
        private final Class<? extends T> clazz;
        private final Method method;

        StaticMethodConverter(Class<? extends T> clazz, Method method) {
            assert (clazz == method.getReturnType());
            this.clazz = clazz;
            this.method = method;
        }

        public T convert(String value) {
            if (value.isEmpty()) {
                return null;
            }
            try {
                return this.clazz.cast(this.method.invoke(null, value));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw ConfigMessages.msg.staticMethodConverterFailure(e);
            }
        }

        Object writeReplace() {
            return new Serialized(this.method.getDeclaringClass(), this.method.getName(), this.method.getParameterTypes()[0]);
        }

        static final class Serialized
        implements Serializable {
            private static final long serialVersionUID = -6334004040897615452L;
            private final Class<?> c;
            private final String m;
            private final Class<?> p;

            Serialized(Class<?> c, String m, Class<?> p) {
                this.c = c;
                this.m = m;
                this.p = p;
            }

            Object readResolve() throws ObjectStreamException {
                return ImplicitConverters.getConverter(this.c);
            }
        }
    }
}

