/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.elementdesc.adapter.cdi;

import io.smallrye.metrics.SmallRyeMetricsMessages;
import io.smallrye.metrics.elementdesc.AnnotationInfo;
import java.lang.annotation.Annotation;
import org.eclipse.microprofile.metrics.annotation.ConcurrentGauge;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.Gauge;
import org.eclipse.microprofile.metrics.annotation.Metered;
import org.eclipse.microprofile.metrics.annotation.SimplyTimed;
import org.eclipse.microprofile.metrics.annotation.Timed;

public class CDIAnnotationInfo
implements AnnotationInfo {
    private final Annotation annotation;

    CDIAnnotationInfo(Annotation annotation) {
        this.annotation = annotation;
    }

    @Override
    public String name() {
        if (this.annotation instanceof Counted) {
            return ((Counted)this.annotation).name();
        }
        if (this.annotation instanceof ConcurrentGauge) {
            return ((ConcurrentGauge)this.annotation).name();
        }
        if (this.annotation instanceof Gauge) {
            return ((Gauge)this.annotation).name();
        }
        if (this.annotation instanceof Metered) {
            return ((Metered)this.annotation).name();
        }
        if (this.annotation instanceof Timed) {
            return ((Timed)this.annotation).name();
        }
        if (this.annotation instanceof SimplyTimed) {
            return ((SimplyTimed)this.annotation).name();
        }
        throw new IllegalArgumentException("Unknown metric annotation type " + this.annotation.annotationType());
    }

    @Override
    public boolean absolute() {
        if (this.annotation instanceof Counted) {
            return ((Counted)this.annotation).absolute();
        }
        if (this.annotation instanceof ConcurrentGauge) {
            return ((ConcurrentGauge)this.annotation).absolute();
        }
        if (this.annotation instanceof Gauge) {
            return ((Gauge)this.annotation).absolute();
        }
        if (this.annotation instanceof Metered) {
            return ((Metered)this.annotation).absolute();
        }
        if (this.annotation instanceof Timed) {
            return ((Timed)this.annotation).absolute();
        }
        if (this.annotation instanceof SimplyTimed) {
            return ((SimplyTimed)this.annotation).absolute();
        }
        throw SmallRyeMetricsMessages.msg.unknownMetricAnnotationType(this.annotation.annotationType());
    }

    @Override
    public String[] tags() {
        if (this.annotation instanceof Counted) {
            return ((Counted)this.annotation).tags();
        }
        if (this.annotation instanceof ConcurrentGauge) {
            return ((ConcurrentGauge)this.annotation).tags();
        }
        if (this.annotation instanceof Gauge) {
            return ((Gauge)this.annotation).tags();
        }
        if (this.annotation instanceof Metered) {
            return ((Metered)this.annotation).tags();
        }
        if (this.annotation instanceof Timed) {
            return ((Timed)this.annotation).tags();
        }
        if (this.annotation instanceof SimplyTimed) {
            return ((SimplyTimed)this.annotation).tags();
        }
        throw SmallRyeMetricsMessages.msg.unknownMetricAnnotationType(this.annotation.annotationType());
    }

    @Override
    public String unit() {
        if (this.annotation instanceof Counted) {
            return ((Counted)this.annotation).unit();
        }
        if (this.annotation instanceof ConcurrentGauge) {
            return ((ConcurrentGauge)this.annotation).unit();
        }
        if (this.annotation instanceof Gauge) {
            return ((Gauge)this.annotation).unit();
        }
        if (this.annotation instanceof Metered) {
            return ((Metered)this.annotation).unit();
        }
        if (this.annotation instanceof Timed) {
            return ((Timed)this.annotation).unit();
        }
        if (this.annotation instanceof SimplyTimed) {
            return ((SimplyTimed)this.annotation).unit();
        }
        throw SmallRyeMetricsMessages.msg.unknownMetricAnnotationType(this.annotation.annotationType());
    }

    @Override
    public String description() {
        if (this.annotation instanceof Counted) {
            return ((Counted)this.annotation).description();
        }
        if (this.annotation instanceof ConcurrentGauge) {
            return ((ConcurrentGauge)this.annotation).description();
        }
        if (this.annotation instanceof Gauge) {
            return ((Gauge)this.annotation).description();
        }
        if (this.annotation instanceof Metered) {
            return ((Metered)this.annotation).description();
        }
        if (this.annotation instanceof Timed) {
            return ((Timed)this.annotation).description();
        }
        if (this.annotation instanceof SimplyTimed) {
            return ((SimplyTimed)this.annotation).description();
        }
        throw SmallRyeMetricsMessages.msg.unknownMetricAnnotationType(this.annotation.annotationType());
    }

    @Override
    public String displayName() {
        if (this.annotation instanceof Counted) {
            return ((Counted)this.annotation).displayName();
        }
        if (this.annotation instanceof ConcurrentGauge) {
            return ((ConcurrentGauge)this.annotation).displayName();
        }
        if (this.annotation instanceof Gauge) {
            return ((Gauge)this.annotation).displayName();
        }
        if (this.annotation instanceof Metered) {
            return ((Metered)this.annotation).displayName();
        }
        if (this.annotation instanceof Timed) {
            return ((Timed)this.annotation).displayName();
        }
        if (this.annotation instanceof SimplyTimed) {
            return ((SimplyTimed)this.annotation).displayName();
        }
        throw SmallRyeMetricsMessages.msg.unknownMetricAnnotationType(this.annotation.annotationType());
    }

    @Override
    public String annotationName() {
        return this.annotation.annotationType().getName();
    }

    public String toString() {
        return this.annotation.toString();
    }
}

