/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.admin;

import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.ScopeRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;

public class ScopeService {
    private final AuthorizationProvider authorization;
    private final AdminPermissionEvaluator auth;
    private final AdminEventBuilder adminEvent;
    private KeycloakSession session;
    private ResourceServer resourceServer;

    public ScopeService(KeycloakSession session, ResourceServer resourceServer, AuthorizationProvider authorization, AdminPermissionEvaluator auth, AdminEventBuilder adminEvent) {
        this.session = session;
        this.resourceServer = resourceServer;
        this.authorization = authorization;
        this.auth = auth;
        this.adminEvent = adminEvent.resource(ResourceType.AUTHORIZATION_SCOPE);
    }

    @POST
    @NoCache
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response create(ScopeRepresentation scope) {
        this.auth.realm().requireManageAuthorization();
        Scope model = RepresentationToModel.toModel((ScopeRepresentation)scope, (ResourceServer)this.resourceServer, (AuthorizationProvider)this.authorization);
        scope.setId(model.getId());
        this.audit(scope, scope.getId(), OperationType.CREATE);
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)scope).build();
    }

    @Path(value="{id}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response update(@PathParam(value="id") String id, ScopeRepresentation scope) {
        this.auth.realm().requireManageAuthorization();
        scope.setId(id);
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        Scope model = storeFactory.getScopeStore().findById(this.resourceServer, scope.getId());
        if (model == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        RepresentationToModel.toModel((ScopeRepresentation)scope, (ResourceServer)this.resourceServer, (AuthorizationProvider)this.authorization);
        this.audit(scope, OperationType.UPDATE);
        return Response.noContent().build();
    }

    @Path(value="{id}")
    @DELETE
    public Response delete(@PathParam(value="id") String id) {
        this.auth.realm().requireManageAuthorization();
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        Scope scope = storeFactory.getScopeStore().findById(this.resourceServer, id);
        if (scope == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        List resources = storeFactory.getResourceStore().findByScopes(this.resourceServer, Collections.singleton(scope));
        if (!resources.isEmpty()) {
            return ErrorResponse.error("Scopes can not be removed while associated with resources.", Response.Status.BAD_REQUEST);
        }
        PolicyStore policyStore = storeFactory.getPolicyStore();
        List policies = policyStore.findByScopes(this.resourceServer, Collections.singletonList(scope));
        for (Policy policyModel : policies) {
            if (policyModel.getScopes().size() == 1) {
                policyStore.delete(policyModel.getId());
                continue;
            }
            policyModel.removeScope(scope);
        }
        storeFactory.getScopeStore().delete(id);
        this.audit(ModelToRepresentation.toRepresentation((Scope)scope), OperationType.DELETE);
        return Response.noContent().build();
    }

    @Path(value="{id}")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Response findById(@PathParam(value="id") String id) {
        this.auth.realm().requireViewAuthorization();
        Scope model = this.authorization.getStoreFactory().getScopeStore().findById(this.resourceServer, id);
        if (model == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)ModelToRepresentation.toRepresentation((Scope)model)).build();
    }

    @Path(value="{id}/resources")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Response getResources(@PathParam(value="id") String id) {
        this.auth.realm().requireViewAuthorization();
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        Scope model = storeFactory.getScopeStore().findById(this.resourceServer, id);
        if (model == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok(storeFactory.getResourceStore().findByScopes(this.resourceServer, Collections.singleton(model)).stream().map(resource -> {
            ResourceRepresentation representation = new ResourceRepresentation();
            representation.setId(resource.getId());
            representation.setName(resource.getName());
            return representation;
        }).collect(Collectors.toList())).build();
    }

    @Path(value="{id}/permissions")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Response getPermissions(@PathParam(value="id") String id) {
        this.auth.realm().requireViewAuthorization();
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        Scope model = storeFactory.getScopeStore().findById(this.resourceServer, id);
        if (model == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        PolicyStore policyStore = storeFactory.getPolicyStore();
        return Response.ok(policyStore.findByScopes(this.resourceServer, Collections.singletonList(model)).stream().map(policy -> {
            PolicyRepresentation representation = new PolicyRepresentation();
            representation.setId(policy.getId());
            representation.setName(policy.getName());
            representation.setType(policy.getType());
            return representation;
        }).collect(Collectors.toList())).build();
    }

    @Path(value="/search")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public Response find(@QueryParam(value="name") String name) {
        this.auth.realm().requireViewAuthorization();
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        if (name == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Scope model = storeFactory.getScopeStore().findByName(this.resourceServer, name);
        if (model == null) {
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        return Response.ok((Object)ModelToRepresentation.toRepresentation((Scope)model)).build();
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Response findAll(@QueryParam(value="scopeId") String id, @QueryParam(value="name") String name, @QueryParam(value="first") Integer firstResult, @QueryParam(value="max") Integer maxResult) {
        this.auth.realm().requireViewAuthorization();
        EnumMap<Scope.FilterOption, String[]> search = new EnumMap<Scope.FilterOption, String[]>(Scope.FilterOption.class);
        if (id != null && !"".equals(id.trim())) {
            search.put(Scope.FilterOption.ID, new String[]{id});
        }
        if (name != null && !"".equals(name.trim())) {
            search.put(Scope.FilterOption.NAME, new String[]{name});
        }
        return Response.ok(this.authorization.getStoreFactory().getScopeStore().findByResourceServer(this.resourceServer, search, Integer.valueOf(firstResult != null ? firstResult : -1), Integer.valueOf(maxResult != null ? maxResult : 100)).stream().map(scope -> ModelToRepresentation.toRepresentation((Scope)scope)).collect(Collectors.toList())).build();
    }

    private void audit(ScopeRepresentation resource, OperationType operation) {
        this.audit(resource, null, operation);
    }

    private void audit(ScopeRepresentation resource, String id, OperationType operation) {
        if (id != null) {
            this.adminEvent.operation(operation).resourcePath((UriInfo)this.session.getContext().getUri(), id).representation(resource).success();
        } else {
            this.adminEvent.operation(operation).resourcePath((UriInfo)this.session.getContext().getUri()).representation(resource).success();
        }
    }
}

