/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime.client;

import io.quarkus.runtime.TlsConfig;
import io.quarkus.vault.runtime.config.VaultAuthenticationType;
import io.quarkus.vault.runtime.config.VaultBootstrapConfig;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.TrustOptions;
import io.vertx.ext.web.client.WebClientOptions;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.ext.web.client.WebClient;
import org.jboss.logging.Logger;

public class MutinyVertxClientFactory {
    private static final Logger log = Logger.getLogger((String)MutinyVertxClientFactory.class.getName());

    public static WebClient createHttpClient(Vertx vertx, VaultBootstrapConfig vaultBootstrapConfig, TlsConfig tlsConfig) {
        boolean trustAll;
        WebClientOptions options = new WebClientOptions().setConnectTimeout((int)vaultBootstrapConfig.connectTimeout.toMillis()).setIdleTimeout((int)vaultBootstrapConfig.readTimeout.getSeconds() * 2);
        if (vaultBootstrapConfig.nonProxyHosts.isPresent()) {
            options.setNonProxyHosts(vaultBootstrapConfig.nonProxyHosts.get());
        }
        if (trustAll = vaultBootstrapConfig.tls.skipVerify.orElseGet(() -> tlsConfig.trustAll).booleanValue()) {
            MutinyVertxClientFactory.skipVerify(options);
        } else if (vaultBootstrapConfig.tls.caCert.isPresent()) {
            MutinyVertxClientFactory.cacert(options, vaultBootstrapConfig.tls.caCert.get());
        } else if (vaultBootstrapConfig.getAuthenticationType() == VaultAuthenticationType.KUBERNETES && vaultBootstrapConfig.tls.useKubernetesCaCert) {
            MutinyVertxClientFactory.cacert(options, "/var/run/secrets/kubernetes.io/serviceaccount/ca.crt");
        }
        return WebClient.create((Vertx)vertx, (WebClientOptions)options);
    }

    private static void cacert(WebClientOptions options, String cacert) {
        log.debug((Object)("configure tls with " + cacert));
        options.setTrustOptions((TrustOptions)new PemTrustOptions().addCertPath(cacert));
    }

    private static void skipVerify(WebClientOptions options) {
        log.debug((Object)"configure tls with skip-verify");
        options.setTrustAll(true);
        options.setVerifyHost(false);
    }
}

