/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo;

import io.quarkus.gizmo.DescriptorUtils;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Type;

final class AnnotationUtils {
    AnnotationUtils() {
    }

    static void visitAnnotationValue(AnnotationVisitor visitor, String key, Object value) {
        if (value.getClass().isArray()) {
            AnnotationVisitor arrayVisitor = visitor.visitArray(key);
            for (Object arrayValue : (Object[])value) {
                AnnotationUtils.visitAnnotationValue(arrayVisitor, "value", arrayValue);
            }
            arrayVisitor.visitEnd();
        } else if (value instanceof AnnotationInstance) {
            AnnotationInstance annotationInstance = (AnnotationInstance)value;
            String descriptor = DescriptorUtils.objectToDescriptor(annotationInstance.name().toString());
            AnnotationVisitor nestedVisitor = visitor.visitAnnotation(key, descriptor);
            for (AnnotationValue annotationValue : annotationInstance.values()) {
                AnnotationUtils.visitAnnotationValue(nestedVisitor, annotationValue.name(), annotationValue);
            }
            nestedVisitor.visitEnd();
        } else if (value instanceof AnnotationValue) {
            AnnotationValue annotationValue = (AnnotationValue)value;
            if (annotationValue.kind() == AnnotationValue.Kind.NESTED) {
                AnnotationUtils.visitAnnotationValue(visitor, annotationValue.name(), annotationValue.asNested());
            } else if (annotationValue.kind() == AnnotationValue.Kind.CLASS) {
                String descriptor = DescriptorUtils.typeToString(annotationValue.asClass());
                visitor.visit(annotationValue.name(), (Object)Type.getType((String)descriptor));
            } else if (annotationValue.kind() == AnnotationValue.Kind.ENUM) {
                String descriptor = DescriptorUtils.objectToDescriptor(annotationValue.asEnumType().toString());
                visitor.visitEnum(key, descriptor, annotationValue.asEnum());
            } else if (annotationValue.kind() == AnnotationValue.Kind.ARRAY) {
                AnnotationUtils.visitAnnotationValue(visitor, annotationValue.name(), annotationValue.value());
            } else {
                visitor.visit(annotationValue.name(), annotationValue.value());
            }
        } else if (value instanceof Enum) {
            visitor.visitEnum(key, DescriptorUtils.objectToDescriptor(value.getClass()), ((Enum)value).name());
        } else if (value instanceof Class) {
            String descriptor = DescriptorUtils.objectToDescriptor(value);
            visitor.visit(key, (Object)Type.getType((String)descriptor));
        } else {
            visitor.visit(key, value);
        }
    }
}

