/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.Security;
import org.infinispan.security.actions.GetCacheManagerConfigurationAction;
import org.infinispan.security.actions.GetGlobalComponentRegistryAction;
import org.infinispan.security.impl.Authorizer;

final class SecurityActions {
    private SecurityActions() {
    }

    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        return (T)(System.getSecurityManager() != null ? AccessController.doPrivileged(action) : Security.doPrivileged(action));
    }

    static GlobalComponentRegistry getGlobalComponentRegistry(EmbeddedCacheManager cacheManager) {
        return (GlobalComponentRegistry)SecurityActions.doPrivileged(new GetGlobalComponentRegistryAction(cacheManager));
    }

    static GlobalConfiguration getCacheManagerConfiguration(EmbeddedCacheManager cacheManager) {
        return (GlobalConfiguration)SecurityActions.doPrivileged(new GetCacheManagerConfigurationAction(cacheManager));
    }

    static void checkPermission(EmbeddedCacheManager cacheManager, AuthorizationPermission permission) {
        Authorizer authorizer = (Authorizer)SecurityActions.getGlobalComponentRegistry(cacheManager).getComponent(Authorizer.class);
        authorizer.checkPermission(Security.getSubject(), permission);
    }
}

