/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers.startupcheck;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.InspectContainerResponse;
import org.testcontainers.containers.startupcheck.StartupCheckStrategy;
import org.testcontainers.utility.DockerStatus;

public class IsRunningStartupCheckStrategy
extends StartupCheckStrategy {
    @Override
    public StartupCheckStrategy.StartupStatus checkStartupState(DockerClient dockerClient, String containerId) {
        InspectContainerResponse.ContainerState state = this.getCurrentState(dockerClient, containerId);
        if (state.getRunning().booleanValue()) {
            return StartupCheckStrategy.StartupStatus.SUCCESSFUL;
        }
        if (!DockerStatus.isContainerExitCodeSuccess(state)) {
            return StartupCheckStrategy.StartupStatus.FAILED;
        }
        return StartupCheckStrategy.StartupStatus.NOT_YET_KNOWN;
    }
}

