/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.vault;

import io.quarkus.vault.VaultKVSecretEngine;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.keycloak.vault.AbstractVaultProvider;
import org.keycloak.vault.DefaultVaultRawSecret;
import org.keycloak.vault.VaultKeyResolver;
import org.keycloak.vault.VaultRawSecret;

public class QuarkusVaultProvider
extends AbstractVaultProvider {
    private VaultKVSecretEngine secretEngine;
    private String[] kvPaths;

    public QuarkusVaultProvider(VaultKVSecretEngine secretEngine, String[] kvPaths, String realm, List<VaultKeyResolver> keyResolvers) {
        super(realm, keyResolvers);
        this.secretEngine = secretEngine;
        this.kvPaths = kvPaths;
    }

    protected VaultRawSecret obtainSecretInternal(String key) {
        if (this.kvPaths == null) {
            return DefaultVaultRawSecret.forBuffer(Optional.empty());
        }
        for (String path : this.kvPaths) {
            Map secrets = this.secretEngine.readSecret(path);
            String secret = (String)secrets.get(key);
            if (secret == null) continue;
            return DefaultVaultRawSecret.forBuffer(Optional.of(StandardCharsets.UTF_8.encode(CharBuffer.wrap(secret))));
        }
        return DefaultVaultRawSecret.forBuffer(Optional.empty());
    }

    public void close() {
    }
}

