/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.IntFunction;

public abstract class ArrayMap<K, V>
extends AbstractMap<K, V> {
    protected int size;
    protected Object[] keys;
    protected Object[] values;
    protected int modCount;
    private Set<K> keySet;
    private Collection<V> valueCollection;
    private Set<Map.Entry<K, V>> entrySet;

    @Override
    public abstract V get(Object var1);

    @Override
    public abstract V put(K var1, V var2);

    @Override
    public abstract V remove(Object var1);

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean containsValue(Object value) {
        Objects.requireNonNull(value);
        for (int i = 0; i < this.values.length; ++i) {
            Object v = this.values[i];
            if (v == null || !v.equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (this.valueCollection == null) {
            this.valueCollection = new Values();
        }
        return this.valueCollection;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public void clear() {
        this.size = 0;
        ++this.modCount;
        Arrays.fill(this.keys, null);
        Arrays.fill(this.values, null);
    }

    private class It<T>
    implements Iterator<T> {
        private final IntFunction<T> retriever;
        private final int length;
        private final int initialModCount;
        private int last = -1;
        private int pos = 0;
        private T next;

        public It(IntFunction<T> retriever, int length, int initialModCount) {
            this.retriever = retriever;
            this.length = length;
            this.initialModCount = initialModCount;
        }

        @Override
        public boolean hasNext() {
            if (this.initialModCount != ArrayMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.next != null) {
                return true;
            }
            while (this.pos < this.length) {
                this.next = this.retriever.apply(this.pos);
                ++this.pos;
                if (this.next == null) continue;
                this.last = this.pos - 1;
                return true;
            }
            return false;
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                T tmp = this.next;
                this.next = null;
                return tmp;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.initialModCount != ArrayMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            ArrayMap.this.keys[this.last] = null;
            ArrayMap.this.values[this.last] = null;
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new It(i -> {
                Object key = ArrayMap.this.keys[i];
                return key == null ? null : new AbstractMap.SimpleEntry<Object, Object>(key, ArrayMap.this.values[i]);
            }, ArrayMap.this.keys.length, ArrayMap.this.modCount);
        }

        @Override
        public int size() {
            return ArrayMap.this.size();
        }

        @Override
        public void clear() {
            ArrayMap.this.clear();
        }
    }

    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new It<Object>(i -> ArrayMap.this.values[i], ArrayMap.this.values.length, ArrayMap.this.modCount);
        }

        @Override
        public int size() {
            return ArrayMap.this.size();
        }

        @Override
        public void clear() {
            ArrayMap.this.clear();
        }
    }

    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new It<Object>(i -> ArrayMap.this.keys[i], ArrayMap.this.keys.length, ArrayMap.this.modCount);
        }

        @Override
        public int size() {
            return ArrayMap.this.size();
        }

        @Override
        public void clear() {
            ArrayMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            return ArrayMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return ArrayMap.this.remove(o) != null;
        }
    }
}

