/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.locale;

import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import org.jboss.logging.Logger;
import org.keycloak.locale.LocaleSelectorProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.sessions.AuthenticationSessionModel;

public class DefaultLocaleSelectorProvider
implements LocaleSelectorProvider {
    private static final Logger logger = Logger.getLogger(LocaleSelectorProvider.class);
    private KeycloakSession session;

    public DefaultLocaleSelectorProvider(KeycloakSession session) {
        this.session = session;
    }

    public Locale resolveLocale(RealmModel realm, UserModel user) {
        HttpHeaders requestHeaders = this.session.getContext().getRequestHeaders();
        AuthenticationSessionModel session = this.session.getContext().getAuthenticationSession();
        if (!realm.isInternationalizationEnabled()) {
            return Locale.ENGLISH;
        }
        Locale userLocale = this.getUserLocale(realm, session, user, requestHeaders);
        if (userLocale != null) {
            return userLocale;
        }
        String realmDefaultLocale = realm.getDefaultLocale();
        if (realmDefaultLocale != null) {
            return Locale.forLanguageTag(realmDefaultLocale);
        }
        return Locale.ENGLISH;
    }

    private Locale getUserLocale(RealmModel realm, AuthenticationSessionModel session, UserModel user, HttpHeaders requestHeaders) {
        Locale locale = this.getUserSelectedLocale(realm, session);
        if (locale != null) {
            return locale;
        }
        locale = this.getUserProfileSelection(realm, user);
        if (locale != null) {
            return locale;
        }
        locale = this.getClientSelectedLocale(realm, session);
        if (locale != null) {
            return locale;
        }
        locale = this.getLocaleCookieSelection(realm, requestHeaders);
        if (locale != null) {
            return locale;
        }
        locale = this.getAcceptLanguageHeaderLocale(realm, requestHeaders);
        if (locale != null) {
            return locale;
        }
        return null;
    }

    private Locale getUserSelectedLocale(RealmModel realm, AuthenticationSessionModel session) {
        if (session == null) {
            return null;
        }
        String locale = session.getAuthNote("locale_user_requested");
        if (locale == null) {
            return null;
        }
        return this.findLocale(realm, locale);
    }

    private Locale getUserProfileSelection(RealmModel realm, UserModel user) {
        if (user == null) {
            return null;
        }
        String locale = user.getFirstAttribute("locale");
        if (locale == null) {
            return null;
        }
        return this.findLocale(realm, locale);
    }

    private Locale getClientSelectedLocale(RealmModel realm, AuthenticationSessionModel session) {
        if (session == null) {
            return null;
        }
        String locale = session.getAuthNote("locale_client_requested");
        if (locale == null) {
            return null;
        }
        return this.findLocale(realm, locale.split(" "));
    }

    private Locale getLocaleCookieSelection(RealmModel realm, HttpHeaders httpHeaders) {
        if (httpHeaders == null) {
            return null;
        }
        Cookie localeCookie = (Cookie)httpHeaders.getCookies().get("KEYCLOAK_LOCALE");
        if (localeCookie == null) {
            return null;
        }
        return this.findLocale(realm, localeCookie.getValue());
    }

    private Locale getAcceptLanguageHeaderLocale(RealmModel realm, HttpHeaders httpHeaders) {
        if (httpHeaders == null) {
            return null;
        }
        List acceptableLanguages = httpHeaders.getAcceptableLanguages();
        if (acceptableLanguages == null || acceptableLanguages.isEmpty()) {
            return null;
        }
        for (Locale l : acceptableLanguages) {
            Locale locale = this.findLocale(realm, l.toLanguageTag());
            if (locale == null) continue;
            return locale;
        }
        return null;
    }

    private Locale findLocale(RealmModel realm, String ... localeStrings) {
        List supportedLocales = realm.getSupportedLocalesStream().map(Locale::forLanguageTag).collect(Collectors.toList());
        for (String localeString : localeStrings) {
            if (localeString == null) continue;
            Locale result = null;
            Locale search = Locale.forLanguageTag(localeString);
            for (Locale supportedLocale : supportedLocales) {
                if (!supportedLocale.getLanguage().equals(search.getLanguage())) continue;
                if (search.getCountry().equals("") ^ supportedLocale.getCountry().equals("") && result == null) {
                    result = supportedLocale;
                }
                if (!supportedLocale.getCountry().equals(search.getCountry())) continue;
                return supportedLocale;
            }
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public void close() {
    }
}

