/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devservices.h2.deployment;

import io.quarkus.datasource.deployment.spi.DevServicesDatasourceProvider;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceProviderBuildItem;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.runtime.LaunchMode;
import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import org.h2.tools.Server;
import org.jboss.logging.Logger;

public class H2DevServicesProcessor {
    private static final Logger LOG = Logger.getLogger(H2DevServicesProcessor.class);

    @BuildStep
    DevServicesDatasourceProviderBuildItem setupH2() {
        return new DevServicesDatasourceProviderBuildItem("h2", new DevServicesDatasourceProvider(){

            public DevServicesDatasourceProvider.RunningDevServicesDatasource startDatabase(Optional<String> username, Optional<String> password, Optional<String> datasourceName, Optional<String> imageName, Map<String, String> containerProperties, Map<String, String> additionalJdbcUrlProperties, OptionalInt port, LaunchMode launchMode, Optional<Duration> startupTimeout) {
                try {
                    final Server tcpServer = Server.createTcpServer((String[])new String[]{"-tcpPort", port.isPresent() ? String.valueOf(port.getAsInt()) : "0"});
                    tcpServer.start();
                    StringBuilder additionalArgs = new StringBuilder();
                    for (Map.Entry<String, String> i : additionalJdbcUrlProperties.entrySet()) {
                        additionalArgs.append(";");
                        additionalArgs.append(i.getKey());
                        additionalArgs.append("=");
                        additionalArgs.append(i.getValue());
                    }
                    LOG.info((Object)"Dev Services for H2 started.");
                    final String connectionUrl = "jdbc:h2:tcp://localhost:" + tcpServer.getPort() + "/mem:" + datasourceName.orElse("default") + ";DB_CLOSE_DELAY=-1" + additionalArgs.toString();
                    return new DevServicesDatasourceProvider.RunningDevServicesDatasource(connectionUrl, "sa", "sa", new Closeable(){

                        @Override
                        public void close() throws IOException {
                            if (tcpServer.isRunning(false)) {
                                try (Connection connection = DriverManager.getConnection(connectionUrl, "sa", "sa");
                                     Statement statement = connection.createStatement();){
                                    statement.execute("SET DB_CLOSE_DELAY 0");
                                }
                                catch (SQLException t) {
                                    t.printStackTrace();
                                }
                                tcpServer.stop();
                                LOG.info((Object)("Dev Services for H2 shut down; server status: " + tcpServer.getStatus()));
                            } else {
                                LOG.info((Object)("Dev Services for H2 was NOT shut down as it appears it was down already; server status: " + tcpServer.getStatus()));
                            }
                        }
                    });
                }
                catch (SQLException throwables) {
                    throw new RuntimeException(throwables);
                }
            }

            public boolean isDockerRequired() {
                return false;
            }
        });
    }
}

