/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan;

import java.util.List;
import java.util.stream.Stream;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialModel;
import org.keycloak.models.SubjectCredentialManager;

public abstract class SubjectCredentialManagerCacheAdapter
implements SubjectCredentialManager {
    private final SubjectCredentialManager subjectCredentialManager;

    protected SubjectCredentialManagerCacheAdapter(SubjectCredentialManager subjectCredentialManager) {
        this.subjectCredentialManager = subjectCredentialManager;
    }

    public abstract void invalidateCacheForEntity();

    public boolean isValid(List<CredentialInput> inputs) {
        this.invalidateCacheForEntity();
        return this.subjectCredentialManager.isValid(inputs);
    }

    public boolean updateCredential(CredentialInput input) {
        this.invalidateCacheForEntity();
        return this.subjectCredentialManager.updateCredential(input);
    }

    public void updateStoredCredential(CredentialModel cred) {
        this.invalidateCacheForEntity();
        this.subjectCredentialManager.updateStoredCredential(cred);
    }

    public CredentialModel createStoredCredential(CredentialModel cred) {
        this.invalidateCacheForEntity();
        return this.subjectCredentialManager.createStoredCredential(cred);
    }

    public boolean removeStoredCredentialById(String id) {
        this.invalidateCacheForEntity();
        return this.subjectCredentialManager.removeStoredCredentialById(id);
    }

    public CredentialModel getStoredCredentialById(String id) {
        return this.subjectCredentialManager.getStoredCredentialById(id);
    }

    public Stream<CredentialModel> getStoredCredentialsStream() {
        return this.subjectCredentialManager.getStoredCredentialsStream();
    }

    public Stream<CredentialModel> getStoredCredentialsByTypeStream(String type) {
        return this.subjectCredentialManager.getStoredCredentialsByTypeStream(type);
    }

    public CredentialModel getStoredCredentialByNameAndType(String name, String type) {
        return this.subjectCredentialManager.getStoredCredentialByNameAndType(name, type);
    }

    public boolean moveStoredCredentialTo(String id, String newPreviousCredentialId) {
        this.invalidateCacheForEntity();
        return this.subjectCredentialManager.moveStoredCredentialTo(id, newPreviousCredentialId);
    }

    public void updateCredentialLabel(String credentialId, String userLabel) {
        this.invalidateCacheForEntity();
        this.subjectCredentialManager.updateCredentialLabel(credentialId, userLabel);
    }

    public void disableCredentialType(String credentialType) {
        this.invalidateCacheForEntity();
        this.subjectCredentialManager.disableCredentialType(credentialType);
    }

    public Stream<String> getDisableableCredentialTypesStream() {
        return this.subjectCredentialManager.getDisableableCredentialTypesStream();
    }

    public boolean isConfiguredFor(String type) {
        return this.subjectCredentialManager.isConfiguredFor(type);
    }

    public boolean isConfiguredLocally(String type) {
        return this.subjectCredentialManager.isConfiguredLocally(type);
    }

    public Stream<String> getConfiguredUserStorageCredentialTypesStream() {
        return this.subjectCredentialManager.getConfiguredUserStorageCredentialTypesStream();
    }

    public CredentialModel createCredentialThroughProvider(CredentialModel model) {
        this.invalidateCacheForEntity();
        return this.subjectCredentialManager.createCredentialThroughProvider(model);
    }
}

