/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.cli.command;

import org.keycloak.quarkus.runtime.cli.command.AbstractExportImportCommand;
import picocli.CommandLine;

@CommandLine.Command(name="export", header={"Export data from realms to a file or directory."}, description={"%nExport data from realms to a file or directory."})
public final class Export
extends AbstractExportImportCommand
implements Runnable {
    @CommandLine.Option(names={"--users"}, arity="1", description={"Set how users should be exported. Possible values are: skip, realm_file, same_file, different_files."}, paramLabel="<strategy>", defaultValue="different_files")
    String users;
    @CommandLine.Option(names={"--users-per-file"}, arity="1", description={"Set the number of users per file. It\u2019s used only if --users=different_files."}, paramLabel="<number>", defaultValue="50")
    Integer usersPerFile;
    @CommandLine.Option(names={"--realm"}, arity="1", description={"Set the name of the realm to export. If not set, all realms are going to be exported."}, paramLabel="<realm>")
    String realm;

    public Export() {
        super("export");
    }

    @Override
    protected void doBeforeRun() {
        if (this.realm != null) {
            System.setProperty("keycloak.migration.realmName", this.realm);
        }
        System.setProperty("keycloak.migration.usersExportStrategy", this.users.toUpperCase());
        if (this.usersPerFile != null) {
            System.setProperty("keycloak.migration.usersPerFile", this.usersPerFile.toString());
        }
    }
}

