/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.storage.database.jpa;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableInstance;
import io.quarkus.hibernate.orm.PersistenceUnit;
import java.lang.annotation.Annotation;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.internal.SessionImpl;
import org.keycloak.config.StorageOptions;
import org.keycloak.models.ModelException;
import org.keycloak.models.map.storage.jpa.JpaMapStorageProviderFactory;

public class QuarkusJpaMapStorageProviderFactory
extends JpaMapStorageProviderFactory {
    public String getId() {
        return StorageOptions.StorageType.jpa.getProvider();
    }

    protected EntityManagerFactory createEntityManagerFactory() {
        InjectableInstance instance = Arc.container().select(EntityManagerFactory.class, new Annotation[0]);
        if (instance.isResolvable()) {
            return (EntityManagerFactory)instance.get();
        }
        return this.getEntityManagerFactory("keycloak-default").orElseThrow(() -> new IllegalStateException("Failed to resolve the default entity manager factory"));
    }

    protected EntityManager getEntityManager() {
        EntityManager em = super.getEntityManager();
        try {
            Connection connection = ((SessionImpl)em.unwrap(SessionImpl.class)).connection();
            if (connection.getAutoCommit()) {
                connection.setAutoCommit(false);
            }
        }
        catch (SQLException e) {
            throw new ModelException("unable to set non-auto-commit to false");
        }
        return em;
    }

    protected Connection getConnection() {
        SessionFactoryImpl entityManagerFactory = (SessionFactoryImpl)this.getEntityManagerFactory().unwrap(SessionFactoryImpl.class);
        try {
            return entityManagerFactory.getJdbcServices().getBootstrapJdbcConnectionAccess().obtainConnection();
        }
        catch (SQLException cause) {
            throw new RuntimeException("Failed to obtain JDBC connection", cause);
        }
    }

    private Optional<EntityManagerFactory> getEntityManagerFactory(final String unitName) {
        InjectableInstance instance = Arc.container().select(EntityManagerFactory.class, new Annotation[]{new PersistenceUnit(){

            public Class<? extends Annotation> annotationType() {
                return PersistenceUnit.class;
            }

            public String value() {
                return unitName;
            }
        }});
        if (instance.isResolvable()) {
            return Optional.of((EntityManagerFactory)instance.get());
        }
        return Optional.empty();
    }
}

