/** SNOWPACK INJECT STYLE: @patternfly/react-styles/css/components/Alert/alert.css */
function __snowpack__injectStyle(css) {
  const headEl = document.head || document.getElementsByTagName('head')[0];
  const styleEl = document.createElement('style');
  styleEl.type = 'text/css';
  if (styleEl.styleSheet) {
    styleEl.styleSheet.cssText = css;
  } else {
    styleEl.appendChild(document.createTextNode(css));
  }
  headEl.appendChild(styleEl);
}
__snowpack__injectStyle(".pf-c-alert {\n  --pf-global--Color--100: var(--pf-global--Color--dark-100);\n  --pf-global--Color--200: var(--pf-global--Color--dark-200);\n  --pf-global--BorderColor--100: var(--pf-global--BorderColor--dark-100);\n  --pf-global--primary-color--100: var(--pf-global--primary-color--dark-100);\n  --pf-global--link--Color: var(--pf-global--link--Color--dark);\n  --pf-global--link--Color--hover: var(--pf-global--link--Color--dark--hover);\n  --pf-global--BackgroundColor--100: var(--pf-global--BackgroundColor--light-100);\n}\n\n.pf-c-alert {\n  --pf-c-alert--BoxShadow: var(--pf-global--BoxShadow--lg);\n  --pf-c-alert--BackgroundColor: var(--pf-global--BackgroundColor--100);\n  --pf-c-alert--GridTemplateColumns: max-content 1fr max-content;\n  --pf-c-alert--GridTemplateAreas:\n    \"icon title action\"\n    \". description description\"\n    \". actiongroup actiongroup\";\n  --pf-c-alert--BorderTopWidth: var(--pf-global--BorderWidth--md);\n  --pf-c-alert--BorderTopColor: var(--pf-global--default-color--200);\n  --pf-c-alert--PaddingTop: var(--pf-global--spacer--md);\n  --pf-c-alert--PaddingRight: var(--pf-global--spacer--md);\n  --pf-c-alert--PaddingBottom: var(--pf-global--spacer--md);\n  --pf-c-alert--PaddingLeft: var(--pf-global--spacer--md);\n  --pf-c-alert__FontSize: var(--pf-global--FontSize--sm);\n  --pf-c-alert__toggle--MarginTop: calc(-1 * var(--pf-global--spacer--form-element) - 0.0625rem);\n  --pf-c-alert__toggle--MarginBottom: calc(-1 * var(--pf-global--spacer--form-element));\n  --pf-c-alert__toggle--MarginLeft: calc(-1 * var(--pf-global--spacer--md));\n  --pf-c-alert__toggle-icon--Rotate: 0;\n  --pf-c-alert__toggle-icon--Transition: var(--pf-global--Transition);\n  --pf-c-alert__icon--Color: var(--pf-global--default-color--200);\n  --pf-c-alert__icon--MarginTop: 0.0625rem;\n  --pf-c-alert__icon--MarginRight: var(--pf-global--spacer--sm);\n  --pf-c-alert__icon--FontSize: var(--pf-global--icon--FontSize--md);\n  --pf-c-alert__title--FontWeight: var(--pf-global--FontWeight--bold);\n  --pf-c-alert__title--Color: var(--pf-global--default-color--300);\n  --pf-c-alert__title--max-lines: 1;\n  --pf-c-alert__action--MarginTop: calc(var(--pf-global--spacer--form-element) * -1);\n  --pf-c-alert__action--MarginBottom: calc(var(--pf-global--spacer--form-element) * -1);\n  --pf-c-alert__action--TranslateY: 0.125rem;\n  --pf-c-alert__action--MarginRight: calc(var(--pf-global--spacer--sm) * -1);\n  --pf-c-alert__description--PaddingTop: var(--pf-global--spacer--xs);\n  --pf-c-alert__action-group--PaddingTop-base: var(--pf-global--spacer--xs);\n  --pf-c-alert__action-group--PaddingTop: var(--pf-c-alert__action-group--PaddingTop-base);\n  --pf-c-alert__description--action-group--PaddingTop-base: var(--pf-global--spacer--md);\n  --pf-c-alert__description--action-group--PaddingTop: var(--pf-c-alert__description--action-group--PaddingTop-base);\n  --pf-c-alert__action-group__c-button--not-last-child--MarginRight: var(--pf-global--spacer--lg);\n  --pf-c-alert--m-success--BorderTopColor: var(--pf-global--success-color--100);\n  --pf-c-alert--m-success__icon--Color: var(--pf-global--success-color--100);\n  --pf-c-alert--m-success__title--Color: var(--pf-global--success-color--200);\n  --pf-c-alert--m-danger--BorderTopColor: var(--pf-global--danger-color--100);\n  --pf-c-alert--m-danger__icon--Color: var(--pf-global--danger-color--100);\n  --pf-c-alert--m-danger__title--Color: var(--pf-global--danger-color--200);\n  --pf-c-alert--m-warning--BorderTopColor: var(--pf-global--warning-color--100);\n  --pf-c-alert--m-warning__icon--Color: var(--pf-global--warning-color--100);\n  --pf-c-alert--m-warning__title--Color: var(--pf-global--warning-color--200);\n  --pf-c-alert--m-info--BorderTopColor: var(--pf-global--info-color--100);\n  --pf-c-alert--m-info__icon--Color: var(--pf-global--info-color--100);\n  --pf-c-alert--m-info__title--Color: var(--pf-global--info-color--200);\n  --pf-c-alert--m-inline--BoxShadow: none;\n  --pf-c-alert--m-inline--BackgroundColor: var(--pf-global--palette--cyan-50);\n  --pf-c-alert--m-inline--m-success--BackgroundColor: var(--pf-global--palette--green-50);\n  --pf-c-alert--m-inline--m-danger--BackgroundColor: var(--pf-global--palette--red-50);\n  --pf-c-alert--m-inline--m-warning--BackgroundColor: var(--pf-global--palette--gold-50);\n  --pf-c-alert--m-inline--m-info--BackgroundColor: var(--pf-global--palette--blue-50);\n  --pf-c-alert--m-inline--m-plain--BorderTopWidth: 0;\n  --pf-c-alert--m-inline--m-plain--BackgroundColor: transparent;\n  --pf-c-alert--m-inline--m-plain--PaddingTop: 0;\n  --pf-c-alert--m-inline--m-plain--PaddingRight: 0;\n  --pf-c-alert--m-inline--m-plain--PaddingBottom: 0;\n  --pf-c-alert--m-inline--m-plain--PaddingLeft: 0;\n  --pf-c-alert--m-expandable--GridTemplateColumns: auto max-content 1fr max-content;\n  --pf-c-alert--m-expandable--GridTemplateAreas:\n    \"toggle icon title action\"\n    \". . description description\"\n    \". . actiongroup actiongroup\";\n  --pf-c-alert--m-expandable__description--action-group--PaddingTop: var(--pf-c-alert__action-group--PaddingTop-base);\n  --pf-c-alert--m-expanded__toggle-icon--Rotate: 90deg;\n  --pf-c-alert--m-expanded__description--action-group--PaddingTop: var(--pf-c-alert__description--action-group--PaddingTop-base);\n  color: var(--pf-global--Color--100);\n  position: relative;\n  display: grid;\n  padding: var(--pf-c-alert--PaddingTop) var(--pf-c-alert--PaddingRight) var(--pf-c-alert--PaddingBottom) var(--pf-c-alert--PaddingLeft);\n  font-size: var(--pf-c-alert__FontSize);\n  background-color: var(--pf-c-alert--BackgroundColor);\n  border-top: var(--pf-c-alert--BorderTopWidth) solid var(--pf-c-alert--BorderTopColor);\n  box-shadow: var(--pf-c-alert--BoxShadow);\n  grid-template-columns: var(--pf-c-alert--GridTemplateColumns);\n  grid-template-areas: var(--pf-c-alert--GridTemplateAreas);\n}\n.pf-c-alert.pf-m-success {\n  --pf-c-alert--BorderTopColor: var(--pf-c-alert--m-success--BorderTopColor);\n  --pf-c-alert__icon--Color: var(--pf-c-alert--m-success__icon--Color);\n  --pf-c-alert__title--Color: var(--pf-c-alert--m-success__title--Color);\n  --pf-c-alert--m-inline--BackgroundColor: var(--pf-c-alert--m-inline--m-success--BackgroundColor);\n}\n.pf-c-alert.pf-m-danger {\n  --pf-c-alert--BorderTopColor: var(--pf-c-alert--m-danger--BorderTopColor);\n  --pf-c-alert__icon--Color: var(--pf-c-alert--m-danger__icon--Color);\n  --pf-c-alert__title--Color: var(--pf-c-alert--m-danger__title--Color);\n  --pf-c-alert--m-inline--BackgroundColor: var(--pf-c-alert--m-inline--m-danger--BackgroundColor);\n}\n.pf-c-alert.pf-m-warning {\n  --pf-c-alert--BorderTopColor: var(--pf-c-alert--m-warning--BorderTopColor);\n  --pf-c-alert__icon--Color: var(--pf-c-alert--m-warning__icon--Color);\n  --pf-c-alert__title--Color: var(--pf-c-alert--m-warning__title--Color);\n  --pf-c-alert--m-inline--BackgroundColor: var(--pf-c-alert--m-inline--m-warning--BackgroundColor);\n}\n.pf-c-alert.pf-m-info {\n  --pf-c-alert--BorderTopColor: var(--pf-c-alert--m-info--BorderTopColor);\n  --pf-c-alert__icon--Color: var(--pf-c-alert--m-info__icon--Color);\n  --pf-c-alert__title--Color: var(--pf-c-alert--m-info__title--Color);\n  --pf-c-alert--m-inline--BackgroundColor: var(--pf-c-alert--m-inline--m-info--BackgroundColor);\n}\n.pf-c-alert.pf-m-inline {\n  --pf-c-alert--BoxShadow: var(--pf-c-alert--m-inline--BoxShadow);\n  --pf-c-alert--BackgroundColor: var(--pf-c-alert--m-inline--BackgroundColor);\n}\n.pf-c-alert.pf-m-plain {\n  --pf-c-alert--BorderTopWidth: var(--pf-c-alert--m-inline--m-plain--BorderTopWidth);\n  --pf-c-alert--BackgroundColor: var(--pf-c-alert--m-inline--m-plain--BackgroundColor);\n  --pf-c-alert--PaddingTop: var(--pf-c-alert--m-inline--m-plain--PaddingTop);\n  --pf-c-alert--PaddingRight: var(--pf-c-alert--m-inline--m-plain--PaddingRight);\n  --pf-c-alert--PaddingBottom: var(--pf-c-alert--m-inline--m-plain--PaddingBottom);\n  --pf-c-alert--PaddingLeft: var(--pf-c-alert--m-inline--m-plain--PaddingLeft);\n}\n.pf-c-alert.pf-m-expandable {\n  --pf-c-alert--GridTemplateColumns: var(--pf-c-alert--m-expandable--GridTemplateColumns);\n  --pf-c-alert--GridTemplateAreas: var(--pf-c-alert--m-expandable--GridTemplateAreas);\n  --pf-c-alert__description--action-group--PaddingTop: var(--pf-c-alert--m-expandable__description--action-group--PaddingTop);\n}\n.pf-c-alert.pf-m-expanded {\n  --pf-c-alert__toggle-icon--Rotate: var(--pf-c-alert--m-expanded__toggle-icon--Rotate);\n  --pf-c-alert__description--action-group--PaddingTop: var(--pf-c-alert--m-expanded__description--action-group--PaddingTop);\n}\n\n.pf-c-alert__toggle {\n  margin-top: var(--pf-c-alert__toggle--MarginTop);\n  margin-bottom: var(--pf-c-alert__toggle--MarginBottom);\n  margin-left: var(--pf-c-alert__toggle--MarginLeft);\n}\n\n.pf-c-alert__toggle-icon {\n  display: inline-block;\n  transition: var(--pf-c-alert__toggle-icon--Transition);\n  transform: rotate(var(--pf-c-alert__toggle-icon--Rotate));\n}\n\n.pf-c-alert__icon {\n  grid-area: icon;\n  display: flex;\n  margin-top: var(--pf-c-alert__icon--MarginTop);\n  margin-right: var(--pf-c-alert__icon--MarginRight);\n  font-size: var(--pf-c-alert__icon--FontSize);\n  color: var(--pf-c-alert__icon--Color);\n}\n\n.pf-c-alert__title {\n  grid-area: title;\n  font-weight: var(--pf-c-alert__title--FontWeight);\n  color: var(--pf-c-alert__title--Color);\n  word-break: break-word;\n}\n.pf-c-alert__title.pf-m-truncate {\n  display: -webkit-box;\n  -webkit-box-orient: vertical;\n  -webkit-line-clamp: var(--pf-c-alert__title--max-lines);\n  overflow: hidden;\n}\n\n.pf-c-alert__description {\n  grid-area: description;\n  padding-top: var(--pf-c-alert__description--PaddingTop);\n  word-break: break-word;\n}\n.pf-c-alert__description + .pf-c-alert__action-group {\n  --pf-c-alert__action-group--PaddingTop: var(--pf-c-alert__description--action-group--PaddingTop);\n}\n\n.pf-c-alert__action {\n  grid-area: action;\n  margin-top: var(--pf-c-alert__action--MarginTop);\n  margin-right: var(--pf-c-alert__action--MarginRight);\n  margin-bottom: var(--pf-c-alert__action--MarginBottom);\n  transform: translateY(var(--pf-c-alert__action--TranslateY));\n}\n.pf-c-alert__action > .pf-c-button {\n  --pf-c-button--LineHeight: 1;\n}\n\n.pf-c-alert__action-group {\n  grid-area: actiongroup;\n  padding-top: var(--pf-c-alert__action-group--PaddingTop);\n}\n.pf-c-alert__action-group > .pf-c-button {\n  --pf-c-button--m-link--m-inline--hover--TextDecoration: none;\n}\n.pf-c-alert__action-group > .pf-c-button:not(:last-child) {\n  margin-right: var(--pf-c-alert__action-group__c-button--not-last-child--MarginRight);\n}\n\n.pf-m-overpass-font .pf-c-alert__title {\n  --pf-c-alert__title--FontWeight: var(--pf-global--FontWeight--normal);\n}\n\n:where(.pf-theme-dark) .pf-c-alert {\n  --pf-c-alert--BackgroundColor: var(--pf-global--palette--black-600);\n  --pf-c-alert__title--Color: var(--pf-global--default-color--200);\n  --pf-c-alert--m-success__title--Color: var(--pf-global--success-color--100);\n  --pf-c-alert--m-danger__title--Color: var(--pf-global--danger-color--100);\n  --pf-c-alert--m-warning__title--Color: var(--pf-global--warning-color--100);\n  --pf-c-alert--m-info__title--Color: var(--pf-global--info-color--100);\n  --pf-c-alert--m-inline--BackgroundColor: var(--pf-global--palette--black-600);\n  --pf-c-alert--m-inline--m-success--BackgroundColor: var(--pf-global--palette--black-600);\n  --pf-c-alert--m-inline--m-danger--BackgroundColor: var(--pf-global--palette--black-600);\n  --pf-c-alert--m-inline--m-warning--BackgroundColor: var(--pf-global--palette--black-600);\n  --pf-c-alert--m-inline--m-info--BackgroundColor: var(--pf-global--palette--black-600);\n}");
