/** SNOWPACK INJECT STYLE: @patternfly/react-styles/css/components/Popover/popover.css */
function __snowpack__injectStyle(css) {
  const headEl = document.head || document.getElementsByTagName('head')[0];
  const styleEl = document.createElement('style');
  styleEl.type = 'text/css';
  if (styleEl.styleSheet) {
    styleEl.styleSheet.cssText = css;
  } else {
    styleEl.appendChild(document.createTextNode(css));
  }
  headEl.appendChild(styleEl);
}
__snowpack__injectStyle(".pf-c-popover {\n  --pf-c-popover--FontSize: var(--pf-global--FontSize--sm);\n  --pf-c-popover--MinWidth: calc(var(--pf-c-popover__content--PaddingLeft) + var(--pf-c-popover__content--PaddingRight) + 18.75rem);\n  --pf-c-popover--MaxWidth: calc(var(--pf-c-popover__content--PaddingLeft) + var(--pf-c-popover__content--PaddingRight) + 18.75rem);\n  --pf-c-popover--BoxShadow: var(--pf-global--BoxShadow--lg);\n  --pf-c-popover--m-danger__title-icon--Color: var(--pf-global--danger-color--100);\n  --pf-c-popover--m-warning__title-icon--Color: var(--pf-global--warning-color--100);\n  --pf-c-popover--m-success__title-icon--Color: var(--pf-global--success-color--100);\n  --pf-c-popover--m-info__title-icon--Color: var(--pf-global--info-color--100);\n  --pf-c-popover--m-default__title-icon--Color: var(--pf-global--default-color--200);\n  --pf-c-popover--m-danger__title-text--Color: var(--pf-global--danger-color--200);\n  --pf-c-popover--m-warning__title-text--Color: var(--pf-global--warning-color--200);\n  --pf-c-popover--m-success__title-text--Color: var(--pf-global--success-color--200);\n  --pf-c-popover--m-info__title-text--Color: var(--pf-global--info-color--200);\n  --pf-c-popover--m-default__title-text--Color: var(--pf-global--default-color--300);\n  --pf-c-popover__content--BackgroundColor: var(--pf-global--BackgroundColor--100);\n  --pf-c-popover__content--PaddingTop: var(--pf-global--spacer--md);\n  --pf-c-popover__content--PaddingRight: var(--pf-global--spacer--md);\n  --pf-c-popover__content--PaddingBottom: var(--pf-global--spacer--md);\n  --pf-c-popover__content--PaddingLeft: var(--pf-global--spacer--md);\n  --pf-c-popover__arrow--Width: var(--pf-global--arrow--width-lg);\n  --pf-c-popover__arrow--Height: var(--pf-global--arrow--width-lg);\n  --pf-c-popover__arrow--BoxShadow: var(--pf-global--BoxShadow--lg);\n  --pf-c-popover__arrow--BackgroundColor: var(--pf-global--BackgroundColor--100);\n  --pf-c-popover__arrow--m-top--TranslateX: -50%;\n  --pf-c-popover__arrow--m-top--TranslateY: 50%;\n  --pf-c-popover__arrow--m-top--Rotate: 45deg;\n  --pf-c-popover__arrow--m-right--TranslateX: -50%;\n  --pf-c-popover__arrow--m-right--TranslateY: -50%;\n  --pf-c-popover__arrow--m-right--Rotate: 45deg;\n  --pf-c-popover__arrow--m-bottom--TranslateX: -50%;\n  --pf-c-popover__arrow--m-bottom--TranslateY: -50%;\n  --pf-c-popover__arrow--m-bottom--Rotate: 45deg;\n  --pf-c-popover__arrow--m-left--TranslateX: 50%;\n  --pf-c-popover__arrow--m-left--TranslateY: -50%;\n  --pf-c-popover__arrow--m-left--Rotate: 45deg;\n  --pf-c-popover--c-button--MarginLeft: var(--pf-global--spacer--sm);\n  --pf-c-popover--c-button--Top: calc(var(--pf-c-popover__content--PaddingTop) - var(--pf-global--spacer--form-element));\n  --pf-c-popover--c-button--Right: var(--pf-global--spacer--md);\n  --pf-c-popover--c-button--sibling--PaddingRight: var(--pf-global--spacer--2xl);\n  --pf-c-popover--c-title--MarginBottom: var(--pf-global--spacer--sm);\n  --pf-c-popover__title--MarginBottom: var(--pf-global--spacer--sm);\n  --pf-c-popover__title--LineHeight: var(--pf-global--LineHeight--md);\n  --pf-c-popover__title--FontFamily: var(--pf-global--FontFamily--heading--sans-serif);\n  --pf-c-popover__title--FontSize: var(--pf-global--FontSize--md);\n  --pf-c-popover__title-icon--MarginRight: var(--pf-global--spacer--sm);\n  --pf-c-popover__title-icon--Color: var(--pf-global--Color--100);\n  --pf-c-popover__footer--MarginTop: var(--pf-global--spacer--md);\n  position: relative;\n  min-width: var(--pf-c-popover--MinWidth);\n  max-width: var(--pf-c-popover--MaxWidth);\n  font-size: var(--pf-c-popover--FontSize);\n  box-shadow: var(--pf-c-popover--BoxShadow);\n}\n.pf-c-popover.pf-m-no-padding {\n  --pf-c-popover__content--PaddingTop: 0px;\n  --pf-c-popover__content--PaddingRight: 0px;\n  --pf-c-popover__content--PaddingBottom: 0px;\n  --pf-c-popover__content--PaddingLeft: 0px;\n}\n.pf-c-popover.pf-m-width-auto {\n  --pf-c-popover--MinWidth: auto;\n  --pf-c-popover--MaxWidth: none;\n}\n.pf-c-popover.pf-m-top .pf-c-popover__arrow, .pf-c-popover.pf-m-top-left .pf-c-popover__arrow, .pf-c-popover.pf-m-top-right .pf-c-popover__arrow {\n  bottom: 0;\n  left: 50%;\n  transform: translateX(var(--pf-c-popover__arrow--m-top--TranslateX)) translateY(var(--pf-c-popover__arrow--m-top--TranslateY)) rotate(var(--pf-c-popover__arrow--m-top--Rotate));\n}\n.pf-c-popover.pf-m-bottom .pf-c-popover__arrow, .pf-c-popover.pf-m-bottom-left .pf-c-popover__arrow, .pf-c-popover.pf-m-bottom-right .pf-c-popover__arrow {\n  top: 0;\n  left: 50%;\n  transform: translateX(var(--pf-c-popover__arrow--m-bottom--TranslateX)) translateY(var(--pf-c-popover__arrow--m-bottom--TranslateY)) rotate(var(--pf-c-popover__arrow--m-bottom--Rotate));\n}\n.pf-c-popover.pf-m-left .pf-c-popover__arrow, .pf-c-popover.pf-m-left-top .pf-c-popover__arrow, .pf-c-popover.pf-m-left-bottom .pf-c-popover__arrow {\n  top: 50%;\n  right: 0;\n  transform: translateX(var(--pf-c-popover__arrow--m-left--TranslateX)) translateY(var(--pf-c-popover__arrow--m-left--TranslateY)) rotate(var(--pf-c-popover__arrow--m-left--Rotate));\n}\n.pf-c-popover.pf-m-right .pf-c-popover__arrow, .pf-c-popover.pf-m-right-top .pf-c-popover__arrow, .pf-c-popover.pf-m-right-bottom .pf-c-popover__arrow {\n  top: 50%;\n  left: 0;\n  transform: translateX(var(--pf-c-popover__arrow--m-right--TranslateX)) translateY(var(--pf-c-popover__arrow--m-right--TranslateY)) rotate(var(--pf-c-popover__arrow--m-right--Rotate));\n}\n.pf-c-popover.pf-m-left-top .pf-c-popover__arrow, .pf-c-popover.pf-m-right-top .pf-c-popover__arrow {\n  top: var(--pf-c-popover__arrow--Height);\n}\n.pf-c-popover.pf-m-left-bottom .pf-c-popover__arrow, .pf-c-popover.pf-m-right-bottom .pf-c-popover__arrow {\n  top: auto;\n  bottom: 0;\n}\n.pf-c-popover.pf-m-top-left .pf-c-popover__arrow, .pf-c-popover.pf-m-bottom-left .pf-c-popover__arrow {\n  left: var(--pf-c-popover__arrow--Width);\n}\n.pf-c-popover.pf-m-top-right .pf-c-popover__arrow, .pf-c-popover.pf-m-bottom-right .pf-c-popover__arrow {\n  right: 0;\n  left: auto;\n}\n.pf-c-popover.pf-m-danger {\n  --pf-c-popover__title-icon--Color: var(--pf-c-popover--m-danger__title-icon--Color);\n  --pf-c-popover__title-text--Color: var(--pf-c-popover--m-danger__title-text--Color);\n}\n.pf-c-popover.pf-m-warning {\n  --pf-c-popover__title-icon--Color: var(--pf-c-popover--m-warning__title-icon--Color);\n  --pf-c-popover__title-text--Color: var(--pf-c-popover--m-warning__title-text--Color);\n}\n.pf-c-popover.pf-m-success {\n  --pf-c-popover__title-icon--Color: var(--pf-c-popover--m-success__title-icon--Color);\n  --pf-c-popover__title-text--Color: var(--pf-c-popover--m-success__title-text--Color);\n}\n.pf-c-popover.pf-m-default {\n  --pf-c-popover__title-icon--Color: var(--pf-c-popover--m-default__title-icon--Color);\n  --pf-c-popover__title-text--Color: var(--pf-c-popover--m-default__title-text--Color);\n}\n.pf-c-popover.pf-m-info {\n  --pf-c-popover__title-icon--Color: var(--pf-c-popover--m-info__title-icon--Color);\n  --pf-c-popover__title-text--Color: var(--pf-c-popover--m-info__title-text--Color);\n}\n\n.pf-c-popover__content {\n  position: relative;\n  padding: var(--pf-c-popover__content--PaddingTop) var(--pf-c-popover__content--PaddingRight) var(--pf-c-popover__content--PaddingBottom) var(--pf-c-popover__content--PaddingLeft);\n  background-color: var(--pf-c-popover__content--BackgroundColor);\n}\n.pf-c-popover__content > .pf-c-title {\n  margin-bottom: var(--pf-c-popover--c-title--MarginBottom);\n}\n.pf-c-popover__content > .pf-c-button {\n  position: absolute;\n  top: var(--pf-c-popover--c-button--Top);\n  right: var(--pf-c-popover--c-button--Right);\n}\n.pf-c-popover__content > .pf-c-button + * {\n  padding-right: var(--pf-c-popover--c-button--sibling--PaddingRight);\n}\n\n.pf-c-popover__arrow {\n  position: absolute;\n  width: var(--pf-c-popover__arrow--Width);\n  height: var(--pf-c-popover__arrow--Height);\n  pointer-events: none;\n  background-color: var(--pf-c-popover__arrow--BackgroundColor);\n  box-shadow: var(--pf-c-popover__arrow--BoxShadow);\n}\n\n.pf-c-popover__title {\n  flex: 0 0 auto;\n  margin-bottom: var(--pf-c-popover__title--MarginBottom);\n  font-family: var(--pf-c-popover__title--FontFamily);\n  font-size: var(--pf-c-popover__title--FontSize);\n  line-height: var(--pf-c-popover__title--LineHeight);\n}\n.pf-c-popover__title.pf-m-icon {\n  display: flex;\n}\n\n.pf-c-popover__title-icon {\n  margin-right: var(--pf-c-popover__title-icon--MarginRight);\n  color: var(--pf-c-popover__title-icon--Color);\n}\n\n.pf-c-popover__title-text {\n  color: var(--pf-c-popover__title-text--Color, inherit);\n}\n\n.pf-c-popover__body {\n  word-wrap: break-word;\n}\n\n.pf-c-popover__footer {\n  margin-top: var(--pf-c-popover__footer--MarginTop);\n}\n\n:where(.pf-theme-dark) .pf-c-popover {\n  --pf-c-popover--BoxShadow: none;\n  --pf-c-popover__arrow--BoxShadow: none;\n  --pf-c-popover__arrow--BackgroundColor: var(--pf-c-popover__content--BackgroundColor);\n  --pf-c-popover--m-default__title-text--Color: var(--pf-global--default-color--200);\n  --pf-c-popover--m-info__title-text--Color: var(--pf-global--info-color--100);\n  --pf-c-popover--m-success__title-text--Color: var(--pf-global--success-color--100);\n}\n:where(.pf-theme-dark) .pf-c-popover,\n:where(.pf-theme-dark) .pf-c-popover .pf-c-popover__arrow {\n  border: 4px solid var(--pf-global--BorderColor--400);\n}");
