/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.audit;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.PortUnreachableException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.ErrorManager;
import java.util.logging.Level;
import javax.net.SocketFactory;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.handlers.SyslogHandler;
import org.jboss.logmanager.handlers.TcpOutputStream;
import org.wildfly.common.Assert;
import org.wildfly.security.audit.AuditEndpoint;
import org.wildfly.security.audit.ElytronMessages;
import org.wildfly.security.audit.EventPriority;

public class SyslogAuditEndpoint
implements AuditEndpoint {
    private volatile boolean accepting = true;
    private final SyslogHandler syslogHandler;
    private final TransportErrorManager errorManager;
    private final SyslogHandler.Protocol protocol;
    private final int maxReconnectAttempts;
    private final TcpOutputStream tcpOutputStream;
    private static final int INFINITE_RECONNECT_ATTEMPTS_OVERFLOW_NUMBER = AccessController.doPrivileged(new PrivilegedAction<Integer>(){

        @Override
        public Integer run() {
            return Integer.parseInt(System.getProperty("wildfly.elytron.infinite.reconnect.attempts.overflow.number", "10000"));
        }
    });
    private int currentReconnectAttempts = 0;

    SyslogAuditEndpoint(Builder builder) throws IOException {
        this.maxReconnectAttempts = builder.maxReconnectAttempts;
        this.protocol = builder.ssl ? SyslogHandler.Protocol.SSL_TCP : (builder.tcp ? SyslogHandler.Protocol.TCP : SyslogHandler.Protocol.UDP);
        this.syslogHandler = new SyslogHandler((InetAddress)Assert.checkNotNullParam((String)"serverAddress", (Object)builder.serverAddress), builder.port, SyslogHandler.Facility.SECURITY, builder.format, this.protocol, (String)Assert.checkNotNullParam((String)"hostName", (Object)builder.hostName));
        if (builder.tcp) {
            this.tcpOutputStream = builder.socketFactory != null ? new TcpOutputStream(builder.socketFactory, builder.serverAddress, builder.port){} : new TcpOutputStream(builder.serverAddress, builder.port);
            this.syslogHandler.setOutputStream((OutputStream)this.tcpOutputStream);
        } else {
            this.tcpOutputStream = null;
        }
        this.errorManager = new TransportErrorManager(this.protocol);
        this.syslogHandler.setErrorManager((ErrorManager)this.errorManager);
        this.accept(EventPriority.INFORMATIONAL, "Elytron audit logging enabled with RFC format: " + builder.format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(EventPriority priority, String message) throws IOException {
        if (!this.accepting) {
            return;
        }
        SyslogAuditEndpoint syslogAuditEndpoint = this;
        synchronized (syslogAuditEndpoint) {
            if (!this.accepting) {
                return;
            }
            if (Thread.currentThread().isInterrupted()) {
                this.syslogHandler.close();
                return;
            }
            try {
                this.tryPublish(priority, message);
                if (this.tcpOutputStream == null) {
                    this.currentReconnectAttempts = 0;
                } else if (this.tcpOutputStream.isConnected()) {
                    this.currentReconnectAttempts = 0;
                } else {
                    this.checkAttempts();
                }
            }
            catch (IOException e) {
                this.checkAttempts();
                if (this.protocol != SyslogHandler.Protocol.UDP) {
                    throw e;
                }
                ElytronMessages.audit.tracef((Throwable)e, "Unable to send message on %d try.", this.currentReconnectAttempts);
            }
        }
    }

    private void checkAttempts() throws IOException {
        if (this.accepting) {
            if (this.currentReconnectAttempts == this.maxReconnectAttempts) {
                this.close();
                throw ElytronMessages.audit.syslogMaximumReconnectAttemptsReached(this.currentReconnectAttempts);
            }
            if (this.maxReconnectAttempts != -1) {
                ++this.currentReconnectAttempts;
            } else if (this.currentReconnectAttempts < INFINITE_RECONNECT_ATTEMPTS_OVERFLOW_NUMBER) {
                ++this.currentReconnectAttempts;
            }
        }
    }

    public int getAttempts() {
        if (this.maxReconnectAttempts != -1) {
            return this.currentReconnectAttempts;
        }
        return this.currentReconnectAttempts == INFINITE_RECONNECT_ATTEMPTS_OVERFLOW_NUMBER ? -1 : this.currentReconnectAttempts;
    }

    private static Level toLevel(EventPriority eventPriority) {
        switch (eventPriority) {
            case ALERT: 
            case EMERGENCY: 
            case CRITICAL: 
            case ERROR: {
                return Level.SEVERE;
            }
            case WARNING: {
                return Level.WARNING;
            }
            case INFORMATIONAL: {
                return Level.INFO;
            }
            case OFF: {
                throw ElytronMessages.audit.invalidEventPriority(eventPriority);
            }
        }
        return Level.FINEST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.accepting = false;
        SyslogAuditEndpoint syslogAuditEndpoint = this;
        synchronized (syslogAuditEndpoint) {
            this.syslogHandler.close();
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    private void tryPublish(EventPriority priority, String message) throws IOException {
        this.syslogHandler.doPublish(new ExtLogRecord(SyslogAuditEndpoint.toLevel(priority), message, SyslogAuditEndpoint.class.getName()));
        this.errorManager.getAndThrowError();
    }

    private class TransportErrorManager
    extends ErrorManager {
        private volatile Exception error;
        private SyslogHandler.Protocol transport;

        public TransportErrorManager(SyslogHandler.Protocol transport) {
            this.transport = transport;
        }

        @Override
        public synchronized void error(String msg, Exception ex, int code) {
            this.error = ex;
        }

        void getAndThrowError() throws IOException {
            Exception error = this.error;
            this.error = null;
            if (error != null) {
                this.throwAsIoOrRuntimeException(error);
            }
        }

        void throwAsIoOrRuntimeException(Throwable t) throws IOException {
            if (t instanceof PortUnreachableException && this.transport == SyslogHandler.Protocol.UDP) {
                throw ElytronMessages.audit.udpPortUnavailable(t.getCause());
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    public static class Builder {
        private InetAddress serverAddress;
        private int port;
        private boolean ssl = false;
        private boolean tcp = true;
        private String hostName;
        private SocketFactory socketFactory = null;
        private SyslogHandler.SyslogType format = SyslogHandler.SyslogType.RFC5424;
        private int maxReconnectAttempts = 0;

        Builder() {
        }

        public Builder setServerAddress(InetAddress serverAddress) {
            this.serverAddress = (InetAddress)Assert.checkNotNullParam((String)"serverAddress", (Object)serverAddress);
            return this;
        }

        public Builder setPort(int port) {
            this.port = port;
            return this;
        }

        public Builder setTcp(boolean tcp) {
            this.tcp = tcp;
            return this;
        }

        public Builder setSsl(boolean ssl) {
            this.ssl = ssl;
            return this;
        }

        public Builder setSocketFactory(SocketFactory socketFactory) {
            this.socketFactory = socketFactory;
            return this;
        }

        public Builder setHostName(String hostName) {
            this.hostName = (String)Assert.checkNotNullParam((String)"hostName", (Object)hostName);
            return this;
        }

        public Builder setFormat(SyslogHandler.SyslogType format) {
            this.format = (SyslogHandler.SyslogType)Assert.checkNotNullParam((String)"format", (Object)format);
            return this;
        }

        public Builder setMaxReconnectAttempts(int maxReconnectAttempts) throws IllegalArgumentException {
            if (maxReconnectAttempts < -1) {
                throw ElytronMessages.audit.badReconnectAttemptsNumber(maxReconnectAttempts);
            }
            this.maxReconnectAttempts = maxReconnectAttempts;
            return this;
        }

        public AuditEndpoint build() throws IOException {
            return new SyslogAuditEndpoint(this);
        }
    }
}

