/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.hotRod;

import java.util.Map;
import java.util.stream.Stream;
import org.infinispan.client.hotrod.RemoteCache;
import org.keycloak.models.ActionTokenValueModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.StringKeyConverter;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.QueryParameters;
import org.keycloak.models.map.storage.chm.ConcurrentHashMapCrudOperations;
import org.keycloak.models.map.storage.chm.MapFieldPredicates;
import org.keycloak.models.map.storage.chm.SingleUseObjectKeycloakTransaction;
import org.keycloak.models.map.storage.chm.SingleUseObjectModelCriteriaBuilder;
import org.keycloak.models.map.storage.criteria.DefaultModelCriteria;
import org.keycloak.models.map.storage.hotRod.HotRodMapStorage;
import org.keycloak.models.map.storage.hotRod.common.AbstractHotRodEntity;
import org.keycloak.models.map.storage.hotRod.common.HotRodEntityDelegate;
import org.keycloak.models.map.storage.hotRod.common.HotRodEntityDescriptor;
import org.keycloak.models.map.storage.hotRod.singleUseObject.HotRodSingleUseObjectEntity;
import org.keycloak.models.map.storage.hotRod.singleUseObject.HotRodSingleUseObjectEntityDelegate;

public class SingleUseObjectHotRodMapStorage<K, E extends AbstractHotRodEntity, V extends HotRodEntityDelegate<E> & AbstractEntity, M>
extends HotRodMapStorage<String, HotRodSingleUseObjectEntity, HotRodSingleUseObjectEntityDelegate, ActionTokenValueModel> {
    private final StringKeyConverter<String> keyConverter;
    private final HotRodEntityDescriptor<HotRodSingleUseObjectEntity, HotRodSingleUseObjectEntityDelegate> storedEntityDescriptor;
    private final DeepCloner cloner;

    public SingleUseObjectHotRodMapStorage(RemoteCache<String, HotRodSingleUseObjectEntity> remoteCache, StringKeyConverter<String> keyConverter, HotRodEntityDescriptor<HotRodSingleUseObjectEntity, HotRodSingleUseObjectEntityDelegate> storedEntityDescriptor, DeepCloner cloner) {
        super(remoteCache, keyConverter, storedEntityDescriptor, cloner);
        this.keyConverter = keyConverter;
        this.storedEntityDescriptor = storedEntityDescriptor;
        this.cloner = cloner;
    }

    @Override
    protected MapKeycloakTransaction<HotRodSingleUseObjectEntityDelegate, ActionTokenValueModel> createTransactionInternal(KeycloakSession session) {
        Map fieldPredicates = MapFieldPredicates.getPredicates(this.storedEntityDescriptor.getModelTypeClass());
        return new SingleUseObjectKeycloakTransaction((ConcurrentHashMapCrudOperations)this, this.keyConverter, this.cloner, fieldPredicates);
    }

    @Override
    public HotRodSingleUseObjectEntityDelegate create(HotRodSingleUseObjectEntityDelegate value) {
        if (value.getId() == null) {
            if (value.getUserId() != null && value.getActionId() != null && value.getActionVerificationNonce() != null) {
                value.setId(value.getUserId() + ":" + value.getActionId() + ":" + value.getActionVerificationNonce());
            }
            if (value.getObjectKey() != null) {
                value.setId(value.getObjectKey());
            }
        }
        return super.create(value);
    }

    @Override
    public Stream<HotRodSingleUseObjectEntityDelegate> read(QueryParameters<ActionTokenValueModel> queryParameters) {
        DefaultModelCriteria criteria = queryParameters.getModelCriteriaBuilder();
        if (criteria == null) {
            return Stream.empty();
        }
        SingleUseObjectModelCriteriaBuilder mcb = (SingleUseObjectModelCriteriaBuilder)criteria.flashToModelCriteriaBuilder((ModelCriteriaBuilder)this.createSingleUseObjectCriteriaBuilder());
        if (mcb.isValid()) {
            HotRodSingleUseObjectEntityDelegate value = (HotRodSingleUseObjectEntityDelegate)this.read(mcb.getKey());
            return value != null ? Stream.of(value) : Stream.empty();
        }
        return super.read(queryParameters);
    }

    private SingleUseObjectModelCriteriaBuilder createSingleUseObjectCriteriaBuilder() {
        return new SingleUseObjectModelCriteriaBuilder();
    }
}

