/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.hotRod.userSession;

import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.infinispan.protostream.GeneratedSchema;
import org.infinispan.protostream.annotations.AutoProtoSchemaBuilder;
import org.infinispan.protostream.annotations.ProtoDoc;
import org.infinispan.protostream.annotations.ProtoDocs;
import org.infinispan.protostream.annotations.ProtoField;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.map.annotations.IgnoreForEntityImplementationGenerator;
import org.keycloak.models.map.common.UpdatableEntity;
import org.keycloak.models.map.storage.hotRod.common.AbstractHotRodEntity;
import org.keycloak.models.map.storage.hotRod.common.CommonPrimitivesProtoSchemaInitializer;
import org.keycloak.models.map.storage.hotRod.common.HotRodStringPair;
import org.keycloak.models.map.storage.hotRod.common.HotRodTypesUtils;
import org.keycloak.models.map.storage.hotRod.common.UpdatableHotRodEntityDelegateImpl;
import org.keycloak.models.map.storage.hotRod.userSession.HotRodAuthenticatedClientSessionEntityReference;
import org.keycloak.models.map.storage.hotRod.userSession.HotRodUserSessionEntityDelegate;
import org.keycloak.models.map.storage.hotRod.userSession.HotRodUserSessionEntitySchemaImpl;
import org.keycloak.models.map.userSession.MapAuthenticatedClientSessionEntity;
import org.keycloak.models.map.userSession.MapUserSessionEntity;

@ProtoDocs(value={@ProtoDoc(value="@Indexed"), @ProtoDoc(value="schema-version: 1")})
public class HotRodUserSessionEntity
extends AbstractHotRodEntity {
    @IgnoreForEntityImplementationGenerator
    public static final int VERSION = 1;
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    @ProtoField(number=1)
    public Integer entityVersion = 1;
    @ProtoField(number=2)
    public String id;
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    @ProtoField(number=3)
    public String realmId;
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    @ProtoField(number=4)
    public String userId;
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    @ProtoField(number=5)
    public String brokerSessionId;
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    @ProtoField(number=6)
    public String brokerUserId;
    @ProtoField(number=7)
    public String loginUsername;
    @ProtoField(number=8)
    public String ipAddress;
    @ProtoField(number=9)
    public String authMethod;
    @ProtoField(number=10)
    public Boolean rememberMe;
    @ProtoField(number=11)
    public Long timestamp;
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    @ProtoField(number=12)
    public Long lastSessionRefresh;
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    @ProtoField(number=13)
    public Long expiration;
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    @ProtoField(number=14)
    public Set<HotRodStringPair> notes;
    @ProtoField(number=15)
    public Integer state;
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    @ProtoField(number=16)
    public Set<HotRodAuthenticatedClientSessionEntityReference> authenticatedClientSessions;
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    @ProtoField(number=17)
    public Boolean offline;

    public boolean equals(Object o) {
        return HotRodUserSessionEntityDelegate.entityEquals(this, o);
    }

    public int hashCode() {
        return HotRodUserSessionEntityDelegate.entityHashCode(this);
    }

    public static abstract class AbstractHotRodUserSessionEntityDelegate
    extends UpdatableHotRodEntityDelegateImpl<HotRodUserSessionEntity>
    implements MapUserSessionEntity {
        public String getId() {
            return ((HotRodUserSessionEntity)this.getHotRodEntity()).id;
        }

        public void setId(String id) {
            HotRodUserSessionEntity entity = (HotRodUserSessionEntity)this.getHotRodEntity();
            if (entity.id != null) {
                throw new IllegalStateException("Id cannot be changed");
            }
            entity.id = id;
            entity.updated = entity.updated | id != null;
        }

        public UserSessionModel.SessionPersistenceState getPersistenceState() {
            return UserSessionModel.SessionPersistenceState.PERSISTENT;
        }

        public void setPersistenceState(UserSessionModel.SessionPersistenceState persistenceState) {
            if (persistenceState != null && UserSessionModel.SessionPersistenceState.PERSISTENT != persistenceState) {
                throw new IllegalArgumentException("Transient session should not be stored in the HotRod.");
            }
        }

        @Override
        public boolean isUpdated() {
            return ((HotRodUserSessionEntity)this.getHotRodEntity()).updated || Optional.ofNullable(this.getAuthenticatedClientSessions()).orElseGet(Collections::emptySet).stream().anyMatch(UpdatableEntity::isUpdated);
        }

        @Override
        public void clearUpdatedFlag() {
            ((HotRodUserSessionEntity)this.getHotRodEntity()).updated = false;
            Optional.ofNullable(this.getAuthenticatedClientSessions()).orElseGet(Collections::emptySet).forEach(UpdatableEntity::clearUpdatedFlag);
        }

        public Optional<MapAuthenticatedClientSessionEntity> getAuthenticatedClientSession(String clientUUID) {
            Set<HotRodAuthenticatedClientSessionEntityReference> acss = ((HotRodUserSessionEntity)this.getHotRodEntity()).authenticatedClientSessions;
            if (acss == null || acss.isEmpty()) {
                return Optional.empty();
            }
            return acss.stream().filter(acs -> Objects.equals(acs.clientId, clientUUID)).findFirst().map(HotRodTypesUtils::migrateHotRodAuthenticatedClientSessionEntityReferenceToMapAuthenticatedClientSessionEntity);
        }

        public Boolean removeAuthenticatedClientSession(String clientUUID) {
            Set<HotRodAuthenticatedClientSessionEntityReference> acss = ((HotRodUserSessionEntity)this.getHotRodEntity()).authenticatedClientSessions;
            boolean removed = acss != null && acss.removeIf(uc -> Objects.equals(uc.clientId, clientUUID));
            ((HotRodUserSessionEntity)this.getHotRodEntity()).updated |= removed;
            return removed;
        }

        public void clearAuthenticatedClientSessions() {
            HotRodUserSessionEntity entity = (HotRodUserSessionEntity)this.getHotRodEntity();
            entity.updated = entity.authenticatedClientSessions != null;
            entity.authenticatedClientSessions = null;
        }
    }

    @AutoProtoSchemaBuilder(includeClasses={HotRodUserSessionEntity.class, HotRodAuthenticatedClientSessionEntityReference.class}, schemaFilePath="proto/", schemaPackageName="kc", dependsOn={CommonPrimitivesProtoSchemaInitializer.class})
    public static interface HotRodUserSessionEntitySchema
    extends GeneratedSchema {
        public static final HotRodUserSessionEntitySchema INSTANCE = new HotRodUserSessionEntitySchemaImpl();
    }
}

