/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.model;

import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.paths.PathCollection;
import java.io.Serializable;
import java.util.Objects;

public class AppDependency
implements ResolvedDependency,
Serializable {
    private final AppArtifact artifact;
    private final String scope;
    private int flags;

    public AppDependency(AppArtifact artifact, String scope, int ... flags) {
        this(artifact, scope, false, flags);
    }

    public AppDependency(AppArtifact artifact, String scope, boolean optional, int ... flags) {
        this.artifact = artifact;
        this.scope = scope;
        int tmpFlags = optional ? 1 : 0;
        for (int f : flags) {
            tmpFlags |= f;
        }
        this.flags = tmpFlags;
    }

    public AppArtifact getArtifact() {
        return this.artifact;
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    public void clearFlag(int flag) {
        if ((this.flags & flag) > 0) {
            this.flags ^= flag;
        }
    }

    public int hashCode() {
        return Objects.hash(this.artifact, this.flags, this.scope);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AppDependency other = (AppDependency)obj;
        return Objects.equals(this.artifact, other.artifact) && this.flags == other.flags && Objects.equals(this.scope, other.scope);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.artifact.append(buf).append('(');
        if (this.isDirect()) {
            buf.append("direct ");
        }
        if (this.isOptional()) {
            buf.append("optional ");
        }
        if (this.isWorkspaceModule()) {
            buf.append("local ");
        }
        if (this.isRuntimeExtensionArtifact()) {
            buf.append("extension ");
        }
        if (this.isRuntimeCp()) {
            buf.append("runtime-cp ");
        }
        if (this.isDeploymentCp()) {
            buf.append("deployment-cp ");
        }
        return buf.append(this.scope).append(')').toString();
    }

    @Override
    public String getGroupId() {
        return this.artifact.getGroupId();
    }

    @Override
    public String getArtifactId() {
        return this.artifact.getArtifactId();
    }

    @Override
    public String getClassifier() {
        return this.artifact.getClassifier();
    }

    @Override
    public String getType() {
        return this.artifact.getType();
    }

    @Override
    public String getVersion() {
        return this.artifact.getVersion();
    }

    @Override
    public ArtifactKey getKey() {
        return this.artifact.getKey();
    }

    @Override
    public PathCollection getResolvedPaths() {
        return this.artifact.getResolvedPaths();
    }
}

