/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime;

import org.keycloak.common.Profile;
import org.keycloak.quarkus.runtime.configuration.Configuration;

public class QuarkusProfile
extends Profile {
    public QuarkusProfile() {
        super((Profile.PropertyResolver)new DefaultPropertyResolver());
    }

    private static class DefaultPropertyResolver
    implements Profile.PropertyResolver {
        private DefaultPropertyResolver() {
        }

        public String resolve(String key) {
            if (this.isFeaturePresent(key, this.getCurrentValue("kc.features"))) {
                if (this.isPreviewProfileKey(key)) {
                    return Profile.Type.PREVIEW.name();
                }
                return "enabled";
            }
            if (this.isFeaturePresent(key, this.getCurrentValue("kc.features-disabled")) && !this.isPreviewProfileKey(key)) {
                return "disabled";
            }
            return null;
        }

        private boolean isFeaturePresent(String key, String features) {
            if (features == null) {
                return false;
            }
            for (String feature : features.split(",")) {
                if (this.isPreviewProfileKey(key)) {
                    try {
                        Profile.Type profileType = Profile.Type.valueOf((String)feature);
                        if (Profile.Type.PREVIEW.equals((Object)profileType)) {
                            return true;
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    return false;
                }
                if (!key.substring(key.lastIndexOf(46) + 1).toUpperCase().equals(feature)) continue;
                return true;
            }
            return false;
        }

        private boolean isPreviewProfileKey(String key) {
            return key.equals("keycloak.profile");
        }

        private String getCurrentValue(String name) {
            String enabledFeatures = Configuration.getRawPersistedProperty(name).orElse(null);
            if (enabledFeatures == null) {
                enabledFeatures = Configuration.getRawValue(name);
            }
            if (enabledFeatures == null) {
                return null;
            }
            return enabledFeatures.toUpperCase().replace('-', '_');
        }
    }
}

