/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.cli.command;

import io.quarkus.runtime.Quarkus;
import io.smallrye.config.ConfigValue;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.cli.command.AbstractCommand;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMappers;
import picocli.CommandLine;

@CommandLine.Command(name="show-config", header={"Print out the current configuration."}, description={"%nPrint out the current configuration."})
public final class ShowConfig
extends AbstractCommand
implements Runnable {
    public static final String NAME = "show-config";
    private static final List<String> ignoredPropertyKeys = List.of("kc.config.args", "kc.show.config", "kc.profile", "kc.quarkus-properties-enabled", "kc.home.dir");
    @CommandLine.Parameters(paramLabel="filter", defaultValue="none", description={"Show all configuration options. Use 'all' to show all options."})
    String filter;

    @Override
    public void run() {
        System.setProperty("kc.show.config", this.filter);
        String configArgs = System.getProperty("kc.show.config");
        String profile = Optional.ofNullable(Environment.getCurrentOrPersistedProfile()).orElse("prod");
        Environment.setProfile(profile);
        Map<String, Set<String>> properties = ShowConfig.getPropertiesByGroup();
        this.printRunTimeConfig(properties, profile);
        if (configArgs.equalsIgnoreCase("all")) {
            this.spec.commandLine().getOut().println("Quarkus Configuration:");
            properties.get("quarkus").stream().sorted().forEachOrdered(this::printProperty);
        }
        if (!Boolean.getBoolean("kc.show.config.runtime")) {
            Quarkus.asyncExit((int)0);
        }
    }

    private void printRunTimeConfig(Map<String, Set<String>> properties, String profile) {
        HashSet uniqueNames = new HashSet();
        this.spec.commandLine().getOut().printf("Current Mode: %s%n", Environment.getKeycloakModeFromProfile(profile));
        this.spec.commandLine().getOut().println("Current Configuration:");
        properties.get("kc").stream().sorted().filter(uniqueNames::add).forEachOrdered(this::printProperty);
    }

    private static Map<String, Set<String>> getPropertiesByGroup() {
        final Map<String, Set<String>> properties = StreamSupport.stream(Configuration.getPropertyNames().spliterator(), false).filter(ShowConfig::filterByGroup).collect(Collectors.groupingBy(ShowConfig::groupProperties, Collectors.toSet()));
        StreamSupport.stream(Configuration.getPropertyNames().spliterator(), false).filter(new Predicate<String>(){

            @Override
            public boolean test(String s) {
                ConfigValue configValue = Configuration.getConfigValue(s);
                if (configValue == null) {
                    return false;
                }
                return "PersistedConfigSource".equals(configValue.getConfigSourceName());
            }
        }).filter(ShowConfig::filterByGroup).collect(Collectors.groupingBy(ShowConfig::groupProperties, Collectors.toSet())).forEach(new BiConsumer<String, Set<String>>(){

            @Override
            public void accept(String group, Set<String> propertyNames) {
                properties.computeIfAbsent(group, name -> new HashSet()).addAll(propertyNames);
            }
        });
        return properties;
    }

    private void printProperty(String property) {
        PropertyMapper mapper;
        ConfigValue configValue = Configuration.getConfigValue(property);
        if (configValue.getValue() == null) {
            return;
        }
        if (configValue.getSourceName() == null) {
            return;
        }
        String value = configValue.getRawValue();
        if (value == null) {
            value = configValue.getValue();
        }
        if ((mapper = PropertyMappers.getMapper(property)) != null && mapper.isRunTime()) {
            value = Configuration.getRuntimeProperty(property).orElse(value);
        }
        this.spec.commandLine().getOut().printf("\t%s =  %s (%s)%n", configValue.getName(), PropertyMappers.formatValue(configValue.getName(), value), configValue.getConfigSourceName());
    }

    private static String groupProperties(String property) {
        if (property.startsWith("%")) {
            return "%";
        }
        int endIndex = property.indexOf(46);
        if (endIndex == -1) {
            return "";
        }
        return property.substring(0, endIndex);
    }

    private static boolean filterByGroup(String property) {
        return (property.startsWith("kc") || property.startsWith("quarkus") || property.startsWith("%")) && !ignoredPropertyKeys.contains(property);
    }
}

