/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.interception.jaxrs;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NoContentException;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.ReaderInterceptor;
import org.jboss.resteasy.core.interception.jaxrs.AbstractReaderInterceptorContext;
import org.jboss.resteasy.core.providerfactory.ResteasyProviderFactoryImpl;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.tracing.RESTEasyTracingLogger;

public class ServerReaderInterceptorContext
extends AbstractReaderInterceptorContext {
    private HttpRequest request;

    public ServerReaderInterceptorContext(ReaderInterceptor[] interceptors, ResteasyProviderFactory providerFactory, Class type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> headers, InputStream inputStream, HttpRequest request) {
        super(mediaType, providerFactory, annotations, interceptors, headers, genericType, type, inputStream, RESTEasyTracingLogger.getInstance(request));
        this.request = request;
    }

    @Override
    protected MessageBodyReader resolveReader(MediaType mediaType) {
        MessageBodyReader reader = ((ResteasyProviderFactoryImpl)this.providerFactory).getServerMessageBodyReader(this.type, this.genericType, this.annotations, mediaType, this.tracingLogger);
        return reader;
    }

    @Override
    protected void throwReaderNotFound() {
        throw new NotSupportedException(Messages.MESSAGES.couldNotFindMessageBodyReader(this.genericType, this.mediaType));
    }

    @Override
    protected Object readFrom(MessageBodyReader reader) throws IOException {
        try {
            return super.readFrom(reader);
        }
        catch (NoContentException e) {
            throw new BadRequestException((Throwable)e);
        }
    }

    public Object getProperty(String name) {
        return this.request.getAttribute(name);
    }

    public Collection<String> getPropertyNames() {
        ArrayList<String> names = new ArrayList<String>();
        Enumeration enames = this.request.getAttributeNames();
        while (enames.hasMoreElements()) {
            names.add((String)enames.nextElement());
        }
        return names;
    }

    public void setProperty(String name, Object object) {
        if (object == null) {
            this.request.removeAttribute(name);
        } else {
            this.request.setAttribute(name, object);
        }
    }

    public void removeProperty(String name) {
        this.request.removeAttribute(name);
    }
}

