/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.core;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.api.ThreadSetupHandler;
import io.undertow.servlet.core.WebConnectionImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.WebConnection;

public class ServletUpgradeListener
implements Consumer<ChannelHandlerContext> {
    private final HttpServerExchange exchange;
    private final ThreadSetupHandler.Action<Void, WebConnectionImpl> initAction;
    private final ThreadSetupHandler.Action<Void, Object> destroyAction;

    public ServletUpgradeListener(final InstanceHandle<? extends HttpUpgradeHandler> instance, Deployment deployment, HttpServerExchange exchange) {
        this.exchange = exchange;
        this.initAction = deployment.createThreadSetupAction(new ThreadSetupHandler.Action<Void, WebConnectionImpl>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call(HttpServerExchange exchange, WebConnectionImpl context) {
                DelayedExecutor executor = new DelayedExecutor((Executor)exchange.getIoThread());
                try {
                    ((HttpUpgradeHandler)instance.getInstance()).init((WebConnection)context);
                }
                finally {
                    executor.openGate();
                }
                return null;
            }
        });
        this.destroyAction = new ThreadSetupHandler.Action<Void, Object>(){

            @Override
            public Void call(HttpServerExchange exchange, Object context) throws Exception {
                try {
                    ((HttpUpgradeHandler)instance.getInstance()).destroy();
                }
                finally {
                    instance.release();
                }
                return null;
            }
        };
    }

    @Override
    public void accept(ChannelHandlerContext context) {
        context.channel().closeFuture().addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(){

            public void operationComplete(Future<? super Void> future) throws Exception {
                try {
                    ServletUpgradeListener.this.destroyAction.call(null, null);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        final WebConnectionImpl connection = new WebConnectionImpl();
        context.pipeline().addLast(new ChannelHandler[]{connection});
        this.exchange.getWorker().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ServletUpgradeListener.this.initAction.call(ServletUpgradeListener.this.exchange, connection);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private static final class DelayedExecutor
    implements Executor {
        private final Executor delegate;
        private volatile boolean queue = true;
        private final List<Runnable> tasks = new ArrayList<Runnable>();

        private DelayedExecutor(Executor delegate) {
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(Runnable command) {
            if (!this.queue) {
                this.delegate.execute(command);
            } else {
                DelayedExecutor delayedExecutor = this;
                synchronized (delayedExecutor) {
                    if (!this.queue) {
                        this.delegate.execute(command);
                    } else {
                        this.tasks.add(command);
                    }
                }
            }
        }

        synchronized void openGate() {
            this.queue = false;
            for (Runnable task : this.tasks) {
                this.delegate.execute(task);
            }
        }
    }
}

