/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.common.Version;

public class Profile {
    public static final String PRODUCT_NAME = ProductValue.RHSSO.getName();
    public static final String PROJECT_NAME = ProductValue.KEYCLOAK.getName();
    private static final Logger logger = Logger.getLogger(Profile.class);
    private static Profile CURRENT;
    private final ProductValue product;
    private final ProfileValue profile;
    private final Set<Feature> disabledFeatures = new HashSet<Feature>();
    private final Set<Feature> previewFeatures = new HashSet<Feature>();
    private final Set<Feature> experimentalFeatures = new HashSet<Feature>();
    private final Set<Feature> deprecatedFeatures = new HashSet<Feature>();
    private final PropertyResolver propertyResolver;

    public Profile(PropertyResolver resolver) {
        this.propertyResolver = resolver;
        Config config = new Config();
        this.product = PRODUCT_NAME.toLowerCase().equals(Version.NAME) ? ProductValue.RHSSO : ProductValue.KEYCLOAK;
        this.profile = ProfileValue.valueOf(config.getProfile().toUpperCase());
        block7: for (Feature f : Feature.values()) {
            Boolean enabled = config.getConfig(f);
            Type type = this.product.equals((Object)ProductValue.RHSSO) ? f.getTypeProduct() : f.getTypeProject();
            switch (type) {
                case DEFAULT: {
                    if (enabled == null || enabled.booleanValue()) continue block7;
                    this.disabledFeatures.add(f);
                    continue block7;
                }
                case DEPRECATED: {
                    this.deprecatedFeatures.add(f);
                }
                case DISABLED_BY_DEFAULT: {
                    if (enabled == null || !enabled.booleanValue()) {
                        this.disabledFeatures.add(f);
                        continue block7;
                    }
                    if (!Type.DEPRECATED.equals((Object)type)) continue block7;
                    logger.warnf("Deprecated feature enabled: " + f.name().toLowerCase(), new Object[0]);
                    continue block7;
                }
                case PREVIEW: {
                    this.previewFeatures.add(f);
                    if (!(enabled != null && enabled.booleanValue() || this.profile.equals((Object)ProfileValue.PREVIEW))) {
                        this.disabledFeatures.add(f);
                        continue block7;
                    }
                    logger.info((Object)("Preview feature enabled: " + f.name().toLowerCase()));
                    continue block7;
                }
                case EXPERIMENTAL: {
                    this.experimentalFeatures.add(f);
                    if (enabled == null || !enabled.booleanValue()) {
                        this.disabledFeatures.add(f);
                        continue block7;
                    }
                    logger.warn((Object)("Experimental feature enabled: " + f.name().toLowerCase()));
                }
            }
        }
    }

    private static Profile getInstance() {
        if (CURRENT == null) {
            CURRENT = new Profile(null);
        }
        return CURRENT;
    }

    public static void setInstance(Profile instance) {
        CURRENT = instance;
    }

    public static void init() {
        PropertyResolver resolver = null;
        if (CURRENT != null) {
            resolver = Profile.CURRENT.propertyResolver;
        }
        CURRENT = new Profile(resolver);
    }

    public static String getName() {
        return Profile.getInstance().profile.name().toLowerCase();
    }

    public static Set<Feature> getDisabledFeatures() {
        return Profile.getInstance().disabledFeatures;
    }

    public static Set<Feature> getPreviewFeatures() {
        return Profile.getInstance().previewFeatures;
    }

    public static Set<Feature> getExperimentalFeatures() {
        return Profile.getInstance().experimentalFeatures;
    }

    public static Set<Feature> getDeprecatedFeatures() {
        return Profile.getInstance().deprecatedFeatures;
    }

    public static boolean isFeatureEnabled(Feature feature) {
        return !Profile.getInstance().disabledFeatures.contains((Object)feature);
    }

    public static boolean isProduct() {
        return Profile.getInstance().profile.equals((Object)ProfileValue.PRODUCT);
    }

    private class Config {
        private Properties properties;

        public Config() {
            block7: {
                this.properties = new Properties();
                try {
                    File file;
                    String jbossServerConfigDir = System.getProperty("jboss.server.config.dir");
                    if (jbossServerConfigDir == null || !(file = new File(jbossServerConfigDir, "profile.properties")).isFile()) break block7;
                    try (FileInputStream is = new FileInputStream(file);){
                        this.properties.load(is);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public String getProfile() {
            String profile = this.getProperty("keycloak.profile");
            if (profile != null) {
                return profile;
            }
            profile = this.properties.getProperty("profile");
            if (profile != null) {
                return profile;
            }
            return Version.DEFAULT_PROFILE;
        }

        public Boolean getConfig(Feature feature) {
            String config = this.getProperty("keycloak.profile.feature." + feature.name().toLowerCase());
            if (config == null) {
                config = this.properties.getProperty("feature." + feature.name().toLowerCase());
            }
            if (config == null) {
                return null;
            }
            if (config.equals("enabled")) {
                return Boolean.TRUE;
            }
            if (config.equals("disabled")) {
                return Boolean.FALSE;
            }
            throw new RuntimeException("Invalid value for feature " + config);
        }

        private String getProperty(String name) {
            String value = System.getProperty(name);
            if (value != null) {
                return value;
            }
            if (Profile.this.propertyResolver != null) {
                return Profile.this.propertyResolver.resolve(name);
            }
            return null;
        }
    }

    public static interface PropertyResolver {
        public String resolve(String var1);
    }

    private static enum ProfileValue {
        COMMUNITY,
        PRODUCT,
        PREVIEW;

    }

    private static enum ProductValue {
        KEYCLOAK("Keycloak"),
        RHSSO("RH-SSO");

        private final String name;

        private ProductValue(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum Feature {
        AUTHORIZATION("Authorization Service", Type.DEFAULT),
        ACCOUNT2("New Account Management Console", Type.DEFAULT),
        ACCOUNT_API("Account Management REST API", Type.DEFAULT),
        ADMIN_FINE_GRAINED_AUTHZ("Fine-Grained Admin Permissions", Type.PREVIEW),
        ADMIN2("New Admin Console", Type.DEFAULT),
        DOCKER("Docker Registry protocol", Type.DISABLED_BY_DEFAULT),
        IMPERSONATION("Ability for admins to impersonate users", Type.DEFAULT),
        OPENSHIFT_INTEGRATION("Extension to enable securing OpenShift", Type.PREVIEW),
        SCRIPTS("Write custom authenticators using JavaScript", Type.PREVIEW),
        TOKEN_EXCHANGE("Token Exchange Service", Type.PREVIEW),
        WEB_AUTHN("W3C Web Authentication (WebAuthn)", Type.DEFAULT),
        CLIENT_POLICIES("Client configuration policies", Type.DEFAULT),
        CIBA("OpenID Connect Client Initiated Backchannel Authentication (CIBA)", Type.DEFAULT),
        MAP_STORAGE("New store", Type.EXPERIMENTAL),
        PAR("OAuth 2.0 Pushed Authorization Requests (PAR)", Type.DEFAULT),
        DECLARATIVE_USER_PROFILE("Configure user profiles using a declarative style", Type.PREVIEW),
        DYNAMIC_SCOPES("Dynamic OAuth 2.0 scopes", Type.EXPERIMENTAL),
        CLIENT_SECRET_ROTATION("Client Secret Rotation", Type.PREVIEW),
        STEP_UP_AUTHENTICATION("Step-up Authentication", Type.DEFAULT),
        RECOVERY_CODES("Recovery codes", Type.PREVIEW),
        UPDATE_EMAIL("Update Email Action", Type.PREVIEW);

        private final Type typeProject;
        private final Type typeProduct;
        private String label;

        private Feature(String label, Type type) {
            this(label, type, type);
        }

        private Feature(String label, Type typeProject, Type typeProduct) {
            this.label = label;
            this.typeProject = typeProject;
            this.typeProduct = typeProduct;
        }

        public String getLabel() {
            return this.label;
        }

        public Type getTypeProject() {
            return this.typeProject;
        }

        public Type getTypeProduct() {
            return this.typeProduct;
        }

        public boolean hasDifferentProductType() {
            return this.typeProject != this.typeProduct;
        }
    }

    public static enum Type {
        DEFAULT,
        DISABLED_BY_DEFAULT,
        PREVIEW,
        EXPERIMENTAL,
        DEPRECATED;

    }
}

