/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.quarkus.hibernate.cache;

import java.util.Comparator;
import java.util.function.Supplier;
import javax.transaction.Synchronization;
import org.hibernate.HibernateException;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.cache.spi.entry.CacheEntry;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.jdbc.WorkExecutorVisitable;
import org.hibernate.resource.transaction.spi.TransactionCoordinator;
import org.infinispan.quarkus.hibernate.cache.InternalCache;
import org.infinispan.quarkus.hibernate.cache.InternalDataAccess;
import org.infinispan.quarkus.hibernate.cache.InternalRegion;
import org.infinispan.quarkus.hibernate.cache.VersionedEntry;
import org.jboss.logging.Logger;

final class NonStrictDataAccess
implements InternalDataAccess {
    private static final Logger log = Logger.getLogger(NonStrictDataAccess.class);
    private static final boolean trace = log.isTraceEnabled();
    private final InternalCache cache;
    private final InternalRegion internalRegion;
    private final Comparator versionComparator;
    private final Supplier<Long> nextTimestamp;

    NonStrictDataAccess(InternalCache cache, InternalRegion internalRegion, Comparator versionComparator, RegionFactory regionFactory) {
        this.cache = cache;
        this.internalRegion = internalRegion;
        this.versionComparator = versionComparator;
        this.nextTimestamp = () -> ((RegionFactory)regionFactory).nextTimestamp();
    }

    @Override
    public Object get(Object session, Object key, long txTimestamp) {
        if (txTimestamp < this.internalRegion.getLastRegionInvalidation()) {
            return null;
        }
        Object value = this.cache.getOrNull(key);
        if (value instanceof VersionedEntry) {
            return ((VersionedEntry)value).getValue();
        }
        return value;
    }

    @Override
    public boolean putFromLoad(Object session, Object key, Object value, long txTimestamp, Object version) {
        return this.putFromLoad(session, key, value, txTimestamp, version, false);
    }

    @Override
    public boolean putFromLoad(Object session, Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) {
        Object prev;
        long lastRegionInvalidation = this.internalRegion.getLastRegionInvalidation();
        if (txTimestamp < lastRegionInvalidation) {
            log.tracef("putFromLoad not executed since tx started at %d, before last region invalidation finished = %d", txTimestamp, lastRegionInvalidation);
            return false;
        }
        assert (version != null);
        if (minimalPutOverride && (prev = this.cache.getOrNull(key)) != null) {
            Object oldVersion = this.getVersion(prev);
            if (oldVersion != null) {
                if (this.versionComparator.compare(version, oldVersion) <= 0) {
                    if (trace) {
                        log.tracef("putFromLoad not executed since version(%s) <= oldVersion(%s)", version, oldVersion);
                    }
                    return false;
                }
            } else if (prev instanceof VersionedEntry && txTimestamp <= ((VersionedEntry)prev).getTimestamp()) {
                if (trace) {
                    log.tracef("putFromLoad not executed since tx started at %d and entry was invalidated at %d", txTimestamp, ((VersionedEntry)prev).getTimestamp());
                }
                return false;
            }
        }
        VersionedEntry versioned = new VersionedEntry(value, version, txTimestamp);
        this.cache.compute(key, new VersionedEntry.ComputeFn(versioned, this.internalRegion));
        return true;
    }

    @Override
    public boolean insert(Object session, Object key, Object value, Object version) {
        return false;
    }

    @Override
    public boolean update(Object session, Object key, Object value, Object currentVersion, Object previousVersion) {
        return false;
    }

    @Override
    public void remove(Object session, Object key) {
        TransactionCoordinator transactionCoordinator = ((SharedSessionContractImplementor)session).getTransactionCoordinator();
        RemovalSynchronization sync = new RemovalSynchronization(key, transactionCoordinator);
        transactionCoordinator.getLocalSynchronizations().registerSynchronization((Synchronization)sync);
    }

    @Override
    public void removeAll() {
        this.internalRegion.beginInvalidation();
        try {
            this.cache.invalidateAll();
        }
        finally {
            this.internalRegion.endInvalidation();
        }
    }

    @Override
    public void evict(Object key) {
        this.cache.compute(key, new VersionedEntry.ComputeFn(new VersionedEntry(this.nextTimestamp.get()), this.internalRegion));
    }

    @Override
    public void evictAll() {
        this.internalRegion.beginInvalidation();
        try {
            this.cache.invalidateAll();
        }
        finally {
            this.internalRegion.endInvalidation();
        }
    }

    @Override
    public boolean afterInsert(Object session, Object key, Object value, Object version) {
        assert (value != null);
        assert (version != null);
        long timestamp = ((SharedSessionContractImplementor)session).getTransactionStartTimestamp();
        this.cache.compute(key, new VersionedEntry.ComputeFn(new VersionedEntry(value, version, timestamp), this.internalRegion));
        return true;
    }

    @Override
    public boolean afterUpdate(Object session, Object key, Object value, Object currentVersion, Object previousVersion, SoftLock lock) {
        assert (value != null);
        assert (currentVersion != null);
        long timestamp = ((SharedSessionContractImplementor)session).getTransactionStartTimestamp();
        this.cache.compute(key, new VersionedEntry.ComputeFn(new VersionedEntry(value, currentVersion, timestamp), this.internalRegion));
        return true;
    }

    private Object getVersion(Object value) {
        if (value instanceof CacheEntry) {
            return ((CacheEntry)value).getVersion();
        }
        if (value instanceof VersionedEntry) {
            return ((VersionedEntry)value).getVersion();
        }
        return null;
    }

    private final class RemovalSynchronization
    implements Synchronization {
        private final Object key;
        private final TransactionCoordinator transactionCoordinator;

        private RemovalSynchronization(Object key, TransactionCoordinator transactionCoordinator) {
            this.key = key;
            this.transactionCoordinator = transactionCoordinator;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            switch (status) {
                case 3: 
                case 8: {
                    this.invokeIsolated(true);
                    break;
                }
                default: {
                    this.invokeIsolated(false);
                }
            }
        }

        protected void invokeIsolated(boolean success) {
            block2: {
                try {
                    WorkExecutorVisitable work = (executor, connection) -> {
                        if (success) {
                            NonStrictDataAccess.this.cache.compute(this.key, new VersionedEntry.ComputeFn(new VersionedEntry((Long)NonStrictDataAccess.this.nextTimestamp.get()), NonStrictDataAccess.this.internalRegion));
                        }
                        return null;
                    };
                    this.transactionCoordinator.createIsolationDelegate().delegateWork(work, false);
                }
                catch (HibernateException e) {
                    if (!log.isTraceEnabled()) break block2;
                    log.trace((Object)"Exception during query cache update", (Throwable)e);
                }
            }
        }
    }
}

